<?php
session_start();

include 'db.php';

// ✅ Hanya admin yang bisa akses
if (!isset($_SESSION['username']) || $_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}

// ✅ Koneksi ke database
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("<p style='color:red;'>Koneksi gagal: " . htmlspecialchars($conn->connect_error) . "</p>");
}

$message = "";
$tarif_sekarang = 0;

// ✅ Ambil tarif ongkos kirim saat ini (jika tabel ada dan tidak kosong)
$result = $conn->query("SELECT Ongkos FROM kirim LIMIT 1");
if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $tarif_sekarang = (int)$row['Ongkos'];
} else {
    $tarif_sekarang = 0;
}

// ✅ Jika form disubmit
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $tarif = trim($_POST['tarif'] ?? '');

    if ($tarif === '' || !is_numeric($tarif)) {
        $message = "<p style='color:red;'>❌ Masukkan angka yang valid untuk tarif ongkos kirim.</p>";
    } else {
        $tarif = (int)$tarif;

        $stmt = $conn->prepare("UPDATE kirim SET Ongkos = ?");
        if ($stmt) {
            $stmt->bind_param("i", $tarif);
            if ($stmt->execute()) {
                $message = "<p style='color:green;'>✅ Tarif ongkos kirim berhasil diperbarui untuk semua barang.</p>";
                $tarif_sekarang = $tarif;
            } else {
                $message = "<p style='color:red;'>❌ Gagal memperbarui tarif ongkos kirim: " . htmlspecialchars($stmt->error) . "</p>";
            }
            $stmt->close();
        } else {
            $message = "<p style='color:red;'>❌ Kesalahan pada query update: " . htmlspecialchars($conn->error) . "</p>";
        }
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Tarif Ongkos Kirim Untuk Semua Barang</title>
    <style>
        body {
            font-family: Verdana, sans-serif;
            background-color: #f5f5f5;
        }
        .container {
            text-align: center;
            margin-top: 50px;
        }
        .card {
            background: #fff;
            padding: 25px;
            border-radius: 12px;
            width: 380px;
            box-shadow: 0 0 12px rgba(0,0,0,0.15);
            margin: 0 auto 25px auto;
        }
        input[type=number] {
            width: 90%;
            padding: 8px;
            font-size: 14px;
            border: 1px solid #ccc;
            border-radius: 6px;
        }
        input[type=submit] {
            padding: 10px 20px;
            background: #007BFF;
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            transition: 0.3s;
        }
        input[type=submit]:hover {
            background: #0056b3;
        }
        .info-box {
            background: #eaf7ea;
            border: 1px solid #a6d8a8;
            border-radius: 8px;
            padding: 15px;
            width: 380px;
            font-size: 16px;
            color: #006600;
            margin: 0 auto 20px auto;
            box-shadow: 0 0 6px rgba(0,0,0,0.1);
        }
        .back-btn {
            display: inline-block;
            margin-top: 10px;
            padding: 10px 20px;
            background: #6c757d;
            color: white;
            text-decoration: none;
            border-radius: 6px;
            transition: 0.3s;
        }
        .back-btn:hover {
            background: #5a6268;
        }
    </style>
</head>

<body>
<div class="container">
    <h2>Tarif Ongkos Kirim Untuk Semua Barang</h2>
    <br>

    <div class="card">
        <form method="post">
            <label for="tarif"><b>Tarif Ongkos Kirim Baru (Rp)</b></label><br><br>
            <input type="number" id="tarif" name="tarif" required><br><br>
            <input type="submit" value="Perbarui">
        </form>
        <br>
        <?= $message ?>
    </div>

    <div class="info-box">
        <b>Tarif Ongkos Kirim Saat Ini:</b><br>
        <font size="5"><b>Rp <?= number_format($tarif_sekarang, 0, ',', '.') ?></b></font>
    </div>

    <a href="dashboard.php" class="back-btn">← Kembali ke Dashboard Admin</a>
</div>
</body>
</html>
