<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}


$mysqli = new mysqli($servername, $username, $password, $database);

// Cek koneksi
if ($mysqli->connect_error) {
    die("<p style='color:red;'>Koneksi gagal: " . htmlspecialchars($mysqli->connect_error) . "</p>");
}

// Ambil kata kunci pencarian
$cari = trim($_GET['cari'] ?? '');

// Siapkan query pencarian (tidak case-sensitive, cukup satu kata)
if ($cari !== '') {
    $sql = "SELECT * FROM pelanggan WHERE LOWER(Nama) LIKE LOWER(?) ORDER BY no_id ASC";
    $stmt = $mysqli->prepare($sql);
    $param = "%" . $cari . "%";
    $stmt->bind_param("s", $param);
    $stmt->execute();
    $result = $stmt->get_result();
} else {
    $result = $mysqli->query("SELECT * FROM pelanggan ORDER BY no_id ASC");
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Daftar Pelanggan</title>
<style>
    body {
        font-family: Verdana, sans-serif;
        background-color: #f8f9fa;
    }
    h1 {
        text-align: center;
        margin-top: 30px;
    }
    form {
        text-align: center;
        margin-bottom: 20px;
    }
    input[type="text"] {
        padding: 6px 10px;
        width: 250px;
        font-size: 14px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }
    input[type="submit"] {
        padding: 6px 14px;
        border: none;
        border-radius: 4px;
        background-color: #007bff;
        color: white;
        cursor: pointer;
    }
    input[type="submit"]:hover {
        background-color: #0056b3;
    }
    table {
        border-collapse: collapse;
        width: 90%;
        margin: auto;
        background-color: white;
        box-shadow: 0 0 8px rgba(0,0,0,0.1);
    }
    th {
        background-color: #343a40;
        color: white;
        padding: 10px;
    }
    td {
        padding: 8px;
        text-align: center;
        border-bottom: 1px solid #ddd;
    }
    tr:hover td {
        background-color: #f2f2f2;
    }
    img {
        border-radius: 8px;
        box-shadow: 0 0 5px rgba(0,0,0,0.2);
    }
</style>
</head>
<body>

<h1>📋 Daftar Pelanggan</h1>

<form method="get" action="">
    <input type="text" name="cari" placeholder="Cari nama pelanggan..." value="<?= htmlspecialchars($cari) ?>">
    <input type="submit" value="🔍 Cari">
</form>

<table>
    <tr>
        <th>Nomor</th>
        <th>Nama</th>
        <th>Alamat</th>
        <th>Email</th>
        <th>No. Hape</th>
        <th>Foto</th>
    </tr>

<?php
$nomor = 1;
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $foto = !empty($row['Gbr_plg']) ? "gambar/" . htmlspecialchars($row['Gbr_plg']) : "gambar/default.png";
        echo "<tr>
                <td>{$nomor}</td>
                <td>" . htmlspecialchars($row['Nama']) . "</td>
                <td>" . htmlspecialchars($row['Alamat']) . "</td>
                <td>" . htmlspecialchars($row['Email']) . "</td>
                <td>" . htmlspecialchars($row['No_hape']) . "</td>
                <td><img src='{$foto}' width='100' height='100' alt='Foto'></td>
              </tr>";
        $nomor++;
    }
} else {
    echo "<tr><td colspan='6' style='color:red;'>Tidak ada pelanggan ditemukan.</td></tr>";
}
?>
</table>

</body>
</html>

<?php
$mysqli->close();
?>
