<?php
session_start();

include 'db.php';

// Cek login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// Redirect jika admin
if ($_SESSION['username'] === "admin@admin.com") {
    header("Location: admin_dashboard.php");
    exit;
}

// Koneksi database
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Ambil data pelanggan
$email = $_SESSION['username'];
$stmt = $conn->prepare("SELECT Nama, Alamat, Email, No_hape, Gbr_plg FROM pelanggan WHERE Email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->bind_result($nama, $alamat, $email, $telp, $gambar);
$stmt->fetch();
$stmt->close();

// Ambil nama toko & logo
$stmt = $conn->prepare("SELECT Nama_toko, Gambar_logo FROM logo");
$stmt->execute();
$stmt->bind_result($nama_toko, $logo);
$stmt->fetch();
$stmt->close();

// Ambil daftar barang
$sql = "SELECT no_id, Nama_barang, Harga, Stok, Diskon, Gbr_brg FROM barang";
$result = $conn->query($sql);
?>
<!DOCTYPE html>
<html lang="id">
<head>
  <meta charset="UTF-8">
  <title>Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background-color: #f8f9fa; }
    .card-product { transition: 0.3s; }
    .card-product:hover { transform: scale(1.03); box-shadow: 0 5px 15px rgba(0,0,0,0.2); }
    .price-old { text-decoration: line-through; color: gray; font-size: 0.9em; }
    .badge-discount { position: absolute; top: 10px; right: 10px; }
  </style>
</head>
<body>

<div class="container mt-5">
  <!-- Header Card -->
  <div class="card shadow-lg border-0 rounded-4 mb-4">
    <div class="card-body p-4 text-center">
      <h2>Selamat datang, <?= htmlspecialchars($nama); ?></h2>
      <a href="logout.php" class="btn btn-danger mt-3">Logout</a>
    </div>
  </div>
  
  <!-- Profil -->
  <div class="text-center mb-5">
    <img src="<?= empty($gambar) ? 'gambar/foto_profil_kosong.png' : 'gambar/' . htmlspecialchars($gambar); ?>" 
         alt="Foto Profil" width="150" class="rounded-circle shadow">
    <div class="mt-4">
      <a href="isi_plg.php" class="btn btn-outline-primary btn-sm mx-1">Daftar Akun</a>
      <a href="update_plg.php" class="btn btn-outline-warning btn-sm mx-1">Edit Akun</a>
      <a href="cekout2.php" class="btn btn-outline-success btn-sm mx-1">Check Out</a>
      <a href="keranjang.php" class="btn btn-outline-info btn-sm mx-1">Keranjang</a>
      <a href="kosong_keranjang.php" class="btn btn-outline-danger btn-sm mx-1">Kosongkan Keranjang</a>
    </div>
  </div>

  <!-- Etalase -->
  <div class="text-center mb-4">
    <h2 class="fw-bold">Etalase <?= htmlspecialchars($nama_toko); ?></h2>
    <?php if (!empty($logo)): ?>
      <img src="gambar/<?= htmlspecialchars($logo); ?>" alt="Logo Toko" width="100" class="mt-2">
    <?php endif; ?>
  </div>

  <div class="row g-4">
    <?php if ($result && $result->num_rows > 0): ?>
        <?php while ($row = $result->fetch_assoc()): ?>
          <?php 
              $harga_asli = $row['Harga'];
              $diskon = $row['Diskon'];
              $harga_diskon = $diskon > 0 ? $harga_asli - ($harga_asli * $diskon / 100) : $harga_asli;
          ?>
          <div class="col-12 col-md-6 col-lg-4">
            <div class="card card-product h-100 shadow-sm border-0 rounded-4 position-relative">
              <?php if ($diskon > 0): ?>
                <span class="badge bg-danger badge-discount">-<?= $diskon; ?>%</span>
              <?php endif; ?>
              
              <img src="gambar/<?= htmlspecialchars($row['Gbr_brg']); ?>" 
                   class="card-img-top rounded-top-4" 
                   alt="<?= htmlspecialchars($row['Nama_barang']); ?>" 
                   style="width:100%; height:275px; object-fit:cover;">
              
              <div class="card-body text-center">
                <h5 class="card-title mb-2"><?= htmlspecialchars($row['Nama_barang']); ?></h5>

                <?php if ($diskon > 0): ?>
                  <p class="mb-1">
                    <span class="price-old">Rp <?= number_format($harga_asli, 0, ',', '.'); ?></span><br>
                    <span class="text-danger fw-bold">Rp <?= number_format($harga_diskon, 0, ',', '.'); ?></span>
                  </p>
                <?php else: ?>
                  <p class="fw-bold text-dark mb-1">Rp <?= number_format($harga_asli, 0, ',', '.'); ?></p>
                <?php endif; ?>

                <p class="text-secondary mb-3">Stok: <?= htmlspecialchars($row['Stok']); ?></p>

                <form action="beli.php" method="post">
                    <input type="hidden" name="nama_barang" value="<?= htmlspecialchars($row['Nama_barang']); ?>">
                    <input type="hidden" name="id_barang" value="<?= htmlspecialchars($row['no_id']); ?>">
                    <input type="hidden" name="diskon" value="<?= htmlspecialchars($row['Diskon']); ?>">
                    <div class="input-group input-group-sm justify-content-center mb-3" style="max-width:150px;">
                      <input type="number" class="form-control text-center" 
                             name="jumlah_beli" min="1" max="<?= htmlspecialchars($row['Stok']); ?>" value="1">
                    </div>
                    <button type="submit" class="btn btn-primary btn-sm">Beli</button>
                </form>
              </div>
            </div>
          </div>
        <?php endwhile; ?>
    <?php else: ?>
        <div class="text-center">
          <p>Belum ada barang.</p>
        </div>
    <?php endif; ?>
  </div>
</div>

</body>
</html>

<?php
$conn->close();
?>
