<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}


$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("<h3 style='color:red;text-align:center;'>Koneksi gagal: " . htmlspecialchars($conn->connect_error) . "</h3>");
}

$pesan_backup = $pesan1 = $pesan2 = "";

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['hapus'])) {

    // ===== 1️⃣ Buat file backup =====
    $tanggal = date("Ymd_His");
    $backup_dir = __DIR__ . "/backup";
    if (!is_dir($backup_dir)) {
        mkdir($backup_dir, 0777, true);
    }
    $backup_file = $backup_dir . "/backup_transaksi_" . $tanggal . ".sql";

    $hasil = $conn->query("SELECT * FROM transaksi");
    if ($hasil && $hasil->num_rows > 0) {
        $sql_data = "-- Backup tabel transaksi (" . date("Y-m-d H:i:s") . ")\n";
        while ($row = $hasil->fetch_assoc()) {
            $values = [];
            foreach ($row as $v) {
                $v = $conn->real_escape_string($v);
                $values[] = "'" . $v . "'";
            }
            $sql_data .= "INSERT INTO transaksi VALUES(" . implode(",", $values) . ");\n";
        }
        file_put_contents($backup_file, $sql_data);
        $pesan_backup = "<span style='color:green;'>📁 Backup berhasil dibuat: <b>backup/" . basename($backup_file) . "</b></span>";
    } else {
        $pesan_backup = "<span style='color:orange;'>⚠️ Tidak ada data untuk dibackup (tabel kosong).</span>";
    }

    // ===== 2️⃣ Hapus semua isi tabel =====
    if ($conn->query("DELETE FROM transaksi") === TRUE) {
        $pesan1 = "<span style='color:green;'>✔️ Tabel <b>transaksi</b> berhasil dikosongkan.</span>";
    } else {
        $pesan1 = "<span style='color:red;'>❌ Gagal mengosongkan tabel transaksi: " . htmlspecialchars($conn->error) . "</span>";
    }

    // ===== 3️⃣ Reset auto increment =====
    if ($conn->query("ALTER TABLE transaksi AUTO_INCREMENT = 1") === TRUE) {
        $pesan2 = "<span style='color:green;'>✔️ Nomor transaksi dimulai lagi dari 1.</span>";
    } else {
        $pesan2 = "<span style='color:red;'>❌ Gagal mereset nomor transaksi: " . htmlspecialchars($conn->error) . "</span>";
    }
}

$conn->close();
?>

<html>
<head>
    <title>Reset Data Transaksi</title>
    <style>
        body {
            background-color: #f8f9fa;
            font-family: Verdana, sans-serif;
            color: #333;
        }
        .container {
            margin: 60px auto;
            width: 80%;
            max-width: 700px;
            background: white;
            border: 1px solid #ccc;
            padding: 40px;
            border-radius: 10px;
            text-align: center;
            box-shadow: 0 0 10px rgba(0,0,0,0.2);
        }
        h1 {
            color: #cc0000;
        }
        .btn {
            padding: 12px 20px;
            font-size: 16px;
            font-weight: bold;
            color: white;
            background-color: #cc0000;
            border: none;
            border-radius: 6px;
            cursor: pointer;
        }
        .btn:hover {
            background-color: #990000;
        }
        a {
            text-decoration: none;
            color: #0056b3;
        }
        a:hover {
            text-decoration: underline;
        }
        .message {
            font-size: 16px;
            margin: 15px 0;
        }
    </style>
    <script>
        function konfirmasiHapus() {
            return confirm("⚠️ Apakah Anda yakin ingin mengosongkan seluruh data transaksi?\n\nSistem akan membuat file backup otomatis di folder 'backup/'.");
        }
    </script>
</head>
<body>
<div class="container">
    <h1>🔄 Reset Data Transaksi</h1>

    <?php if ($pesan1 || $pesan2): ?>
        <div class="message"><?php echo $pesan_backup; ?></div>
        <div class="message"><?php echo $pesan1; ?></div>
        <div class="message"><?php echo $pesan2; ?></div>
        <br>
        <a href="admin_dashboard.php">⬅️ Kembali ke Menu Utama</a>
    <?php else: ?>
        <p style="font-size:16px;">Tombol di bawah ini akan:
            <br>1️⃣ Membuat <b>file backup transaksi</b> di folder <code>backup/</code>
            <br>2️⃣ Menghapus seluruh isi tabel
            <br>3️⃣ Mengatur ulang nomor urut ke 1.</p>
        <form method="post" onsubmit="return konfirmasiHapus();">
            <button type="submit" name="hapus" class="btn">🗑️ Backup & Kosongkan Transaksi</button>
        </form>
        <br><br>
        <a href="admin_dashboard.php">⬅️ Batal dan Kembali</a>
    <?php endif; ?>
</div>
</body>
</html>
