<?php
session_start();

include 'db.php';


if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

$jml_beli = (int) ($_POST['jumlah_beli'] ?? 0);
$nama_brg = trim($_POST['nama_barang'] ?? '');
$email = trim($_SESSION['username'] ?? '');
$diskon_input = (int) ($_POST['diskon'] ?? 0); // diskon dari form

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// --- Ambil data barang ---
$stmt = $conn->prepare("SELECT no_id, Nama_barang, Harga, Stok FROM barang WHERE Nama_barang = ?");
$stmt->bind_param("s", $nama_brg);
$stmt->execute();
$stmt->bind_result($nomor_id, $nama_barang, $harga_barang, $stok_barang);
$stmt->fetch();
$stmt->close();

// Pastikan data barang ditemukan
if (empty($nama_barang)) {
    die("Barang '$nama_brg' tidak ditemukan!");
}

// --- Hitung harga setelah diskon ---
$nilai_diskon = $harga_barang * ($diskon_input / 100);
$harga_setelah_diskon = $harga_barang - $nilai_diskon;

// Simpan ke session
$_SESSION['nomor_id'] = $nomor_id;
$_SESSION['jml_beli'] = $jml_beli;
$_SESSION['rego'] = $harga_barang;
$_SESSION['stok_baru'] = $stok_barang - $jml_beli;
$_SESSION['harga_baru'] = $harga_setelah_diskon;

// --- Ambil data pelanggan ---
$stmt = $conn->prepare("SELECT no_id, Nama, Alamat, No_hape FROM pelanggan WHERE Email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->bind_result($no_id_plg, $nama_plg, $alamat_plg, $no_hp_plg);
$stmt->fetch();
$stmt->close();
$conn->close();

$_SESSION['nomor_id_plg'] = $no_id_plg;

$data_barang = [
    'Nama_barang' => $nama_barang,
    'Harga' => $harga_barang,
    'Diskon' => $diskon_input
];

$data_plg = [
    'Nama' => $nama_plg,
    'Alamat' => $alamat_plg,
    'No_hape' => $no_hp_plg
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Data Pembelian</title>
<style>
    body { font-family: Verdana; background: #f7f9fc; color: #333; text-align: center; }
    h1 { color: #2c3e50; margin-top: 30px; }
    table {
        margin: 30px auto;
        border-collapse: collapse;
        width: 60%;
        background: white;
        box-shadow: 0 0 10px rgba(0,0,0,0.1);
        border-radius: 10px;
        overflow: hidden;
    }
    th, td { padding: 12px 20px; border-bottom: 1px solid #ddd; text-align: left; }
    th { background-color: #007bff; color: white; }
    tr:hover { background-color: #f1f1f1; }
    a { text-decoration: none; color: #007bff; font-weight: bold; margin: 0 15px; }
    a:hover { color: #0056b3; }
</style>
</head>
<body>

<h1>Data Pembelian</h1>

<table>
    <tr><th>Nama Barang</th><td><?= htmlspecialchars($data_barang['Nama_barang']) ?></td></tr>
    <tr><th>Harga Asli</th><td><?= number_format($data_barang['Harga'], 0, ',', '.') ?></td></tr>
    <tr><th>Diskon</th><td><?= htmlspecialchars($data_barang['Diskon']) ?>%</td></tr>
    <tr><th>Harga Setelah Diskon</th><td><?= number_format($harga_setelah_diskon, 0, ',', '.') ?></td></tr>
    <tr><th>Jumlah Beli</th><td><?= htmlspecialchars($jml_beli) ?></td></tr>
    <tr><th>Nama Pembeli</th><td><?= htmlspecialchars($data_plg['Nama'] ?? '-') ?></td></tr>
    <tr><th>Alamat</th><td><?= htmlspecialchars($data_plg['Alamat'] ?? '-') ?></td></tr>
    <tr><th>Email</th><td><?= htmlspecialchars($email) ?></td></tr>
    <tr><th>No HP</th><td><?= htmlspecialchars($data_plg['No_hape'] ?? '-') ?></td></tr>
</table>

<div>
    <a href="bayar.php">[Lanjutkan]</a>
    <a href="dashboard.php">[Kembali]</a>
</div>

</body>
</html>
