<?php
session_start();

include 'db.php';

// Cek login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

$pesan = "";
$nama_baru = $alamat_baru = $no_hape_baru = $gbr_plg_baru = "";

// Koneksi ke database
$conn = new mysqli($servername, $username, $password, $database);

if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Ambil data pelanggan saat ini
$stmt = $conn->prepare("SELECT Nama, Alamat, Email, No_hape, Gbr_plg FROM pelanggan WHERE Email = ?");
$stmt->bind_param("s", $_SESSION['username']);
$stmt->execute();
$stmt->bind_result($nama_baru, $alamat_baru, $email_baru, $no_hape_baru, $gbr_plg_baru);
$stmt->fetch();
$stmt->close();

// Jika form disubmit
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $nama   = trim($_POST['nama'] ?? '');
    $alamat = trim($_POST['alamat'] ?? '');
    $telp   = trim($_POST['telp'] ?? '');
    $nama_file = $gbr_plg_baru; // default: foto lama

    // Jika user upload foto baru
    if (!empty($_FILES["foto"]["tmp_name"])) {
        $target_dir = "gambar/";
        $nama_file = basename($_FILES["foto"]["name"]);
        $target_file = $target_dir . $nama_file;
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
        $uploadOk = 1;

        $check = getimagesize($_FILES["foto"]["tmp_name"]);
        if ($check === false) {
            $pesan .= "File bukan gambar.<br>";
            $uploadOk = 0;
        }

        if (file_exists($target_file)) {
            $pesan .= "Maaf, file sudah ada.<br>";
            $uploadOk = 0;
        }

        if ($_FILES["foto"]["size"] > 5000000) {
            $pesan .= "Maaf, ukuran file terlalu besar (max 5MB).<br>";
            $uploadOk = 0;
        }

        if (!in_array($imageFileType, ["jpg", "jpeg", "png", "gif"])) {
            $pesan .= "Hanya file JPG, JPEG, PNG & GIF yang diizinkan.<br>";
            $uploadOk = 0;
        }

        // Upload file
        if ($uploadOk == 1) {
            if (move_uploaded_file($_FILES["foto"]["tmp_name"], $target_file)) {
                $pesan .= "File <b>" . htmlspecialchars($nama_file) . "</b> berhasil diupload.<br>";
            } else {
                $pesan .= "Maaf, terjadi kesalahan saat mengupload file.<br>";
                $nama_file = $gbr_plg_baru; // gunakan foto lama jika gagal upload
            }
        } else {
            $nama_file = $gbr_plg_baru;
        }
    }

    // Update data pelanggan
    $stmt = $conn->prepare("UPDATE pelanggan SET Nama = ?, Alamat = ?, No_hape = ?, Gbr_plg = ? WHERE Email = ?");
    $stmt->bind_param("sssss", $nama, $alamat, $telp, $nama_file, $_SESSION['username']);

    if ($stmt->execute()) {
        $pesan .= "<b>Data pelanggan berhasil disimpan.</b>";
        // refresh data baru dari database
        $nama_baru = $nama;
        $alamat_baru = $alamat;
        $no_hape_baru = $telp;
        $gbr_plg_baru = $nama_file;
    } else {
        $pesan .= "Error database: " . $stmt->error;
    }

    $stmt->close();
}

$conn->close();
?>

<html>
<head>
<meta charset="UTF-8">
<title>Edit Akun</title>
</head>
<body>
<center>
    <font face="verdana" size="6">Edit Akun</font><br>
    <font face="verdana" size="3">(Email tidak bisa diubah. Jika ingin ubah email, silakan buat akun baru)</font><br><br>

    <?php if (!empty($pesan)) echo "<div style='color:blue;font-family:verdana;'>$pesan</div><br>"; ?>
</center>

<form enctype="multipart/form-data" method="post" action="">
    <font face="verdana" size="2">
    <table cellspacing="0" cellpadding="10" border="0" align="center">
        <tr>
            <td>Nama Lengkap</td>
            <td><input type="text" size="50" name="nama" value="<?= htmlspecialchars($nama_baru); ?>" required></td>
        </tr>
        <tr>
            <td>Alamat</td>
            <td><input type="text" size="50" name="alamat" value="<?= htmlspecialchars($alamat_baru); ?>" required></td>
        </tr>
        <tr>
            <td>Email</td>
            <td><?= htmlspecialchars($_SESSION['username']); ?></td>
        </tr>
        <tr>
            <td>No. Hape</td>
            <td><input type="text" size="50" name="telp" value="<?= htmlspecialchars($no_hape_baru); ?>" required></td>
        </tr>
        <tr>
            <td>Foto Sekarang</td>
            <td>
                <img src="gambar/<?= htmlspecialchars($gbr_plg_baru ?: 'foto_profil_kosong.png'); ?>" width="100"><br>
            </td>
        </tr>
        <tr>
            <td>Ganti Foto</td>
            <td><input type="file" name="foto" accept="image/*"></td>
        </tr>
        <tr>
            <td></td>
            <td><button type="submit">Simpan</button></td>
        </tr>
    </table>
</form>
</body>
</html>
