<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}


$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Filter pencarian
$cari = trim($_GET['cari'] ?? '');
$tanggal = trim($_GET['tanggal'] ?? '');

// Base query
$query = "SELECT * FROM admin_log WHERE 1";
$params = [];
$types = "";

if (!empty($cari)) {
    $query .= " AND (admin LIKE ? OR aksi LIKE ? OR keterangan LIKE ?)";
    $cariLike = "%" . $cari . "%";
    $params = array(&$cariLike, &$cariLike, &$cariLike);
    $types .= "sss";
}

if (!empty($tanggal)) {
    $query .= " AND DATE(waktu) = ?";
    $params[] = &$tanggal;
    $types .= "s";
}

$query .= " ORDER BY waktu DESC";

$stmt = $conn->prepare($query);
if (!empty($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

// === EXPORT EXCEL ===
if (isset($_GET['export']) && $_GET['export'] === 'excel') {
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=riwayat_admin.xls");
    echo "No\tAdmin\tAksi\tWaktu\tKeterangan\n";
    $no = 1;
    while ($row = $result->fetch_assoc()) {
        echo "$no\t{$row['admin']}\t{$row['aksi']}\t{$row['waktu']}\t{$row['keterangan']}\n";
        $no++;
    }
    exit;
}

// === EXPORT PDF ===
if (isset($_GET['export']) && $_GET['export'] === 'pdf') {
    require_once('tcpdf/tcpdf.php'); // pastikan library TCPDF sudah di folder proyekmu

    $pdf = new TCPDF();
    $pdf->AddPage();
    $pdf->SetFont('helvetica', '', 11);

    $html = "<h2 style='text-align:center;'>Riwayat Aksi Admin</h2>";
    $html .= "<table border='1' cellspacing='0' cellpadding='5'>
                <tr style='background-color:#007BFF; color:white;'>
                    <th>No</th><th>Admin</th><th>Aksi</th><th>Waktu</th><th>Keterangan</th>
                </tr>";

    $no = 1;
    $result->data_seek(0);
    while ($row = $result->fetch_assoc()) {
        $html .= "<tr>
                    <td>$no</td>
                    <td>{$row['admin']}</td>
                    <td>{$row['aksi']}</td>
                    <td>{$row['waktu']}</td>
                    <td>{$row['keterangan']}</td>
                  </tr>";
        $no++;
    }
    $html .= "</table>";

    $pdf->writeHTML($html);
    $pdf->Output("riwayat_admin.pdf", "D");
    exit;
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Riwayat Aksi Admin</title>
<style>
body {
    font-family: Arial, sans-serif;
    background: #f7f7f7;
    color: #333;
    padding: 20px;
}
h2 {
    text-align: center;
    color: #222;
}
form {
    background: #fff;
    padding: 15px;
    margin-bottom: 20px;
    border-radius: 8px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}
input[type="text"], input[type="date"] {
    padding: 8px;
    margin-right: 10px;
    border: 1px solid #ccc;
    border-radius: 5px;
}
button {
    padding: 8px 15px;
    background: #007BFF;
    border: none;
    color: white;
    border-radius: 5px;
    cursor: pointer;
}
button:hover {
    background: #0056b3;
}
a.export {
    padding: 8px 15px;
    background: #28a745;
    color: white;
    border-radius: 5px;
    text-decoration: none;
    margin-left: 5px;
}
a.export.pdf {
    background: #dc3545;
}
table {
    width: 100%;
    border-collapse: collapse;
    background: white;
    border-radius: 8px;
    overflow: hidden;
}
th, td {
    border-bottom: 1px solid #ddd;
    padding: 10px;
    text-align: left;
}
th {
    background-color: #007BFF;
    color: white;
}
tr:hover {
    background-color: #f1f1f1;
}
.no-data {
    text-align: center;
    color: #777;
    padding: 20px;
}
.back {
    display: inline-block;
    margin-top: 10px;
    text-decoration: none;
    color: #007BFF;
}
.back:hover {
    text-decoration: underline;
}
</style>
</head>
<body>

<h2>📜 Riwayat Aksi Admin</h2>

<form method="get" action="">
    <input type="text" name="cari" placeholder="Cari kata kunci (hapus, restore, dsb)" value="<?= htmlspecialchars($cari) ?>">
    <input type="date" name="tanggal" value="<?= htmlspecialchars($tanggal) ?>">
    <button type="submit">🔍 Cari</button>
    <a href="riwayat_admin.php" style="margin-left:10px; color:red; text-decoration:none;">❌ Reset</a>
    <a class="export" href="?export=excel&cari=<?= urlencode($cari) ?>&tanggal=<?= urlencode($tanggal) ?>">📊 Export Excel</a>
    <a class="export pdf" href="?export=pdf&cari=<?= urlencode($cari) ?>&tanggal=<?= urlencode($tanggal) ?>">📄 Export PDF</a>
</form>

<table>
    <tr>
        <th>No</th>
        <th>Admin</th>
        <th>Aksi</th>
        <th>Waktu</th>
        <th>Keterangan</th>
    </tr>
    <?php
    if ($result->num_rows > 0) {
        $no = 1;
        while ($row = $result->fetch_assoc()) {
            echo "<tr>
                    <td>{$no}</td>
                    <td>{$row['admin']}</td>
                    <td>{$row['aksi']}</td>
                    <td>{$row['waktu']}</td>
                    <td>{$row['keterangan']}</td>
                  </tr>";
            $no++;
        }
    } else {
        echo "<tr><td colspan='5' class='no-data'>Tidak ada data log ditemukan</td></tr>";
    }
    ?>
</table>

<a class="back" href="admin_dashboard.php">⬅️ Kembali ke Dashboard</a>

</body>
</html>

<?php
$stmt->close();
$conn->close();
?>
