<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}


$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

$message = "";

// Jika tombol aksi ditekan
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $action = $_POST['action'] ?? '';
    $search = trim($_POST['search'] ?? '');

    if ($action === "restore_all") {
        $sql_restore = "INSERT INTO barang (Nama_barang, Harga, Stok, Diskon, Gbr_brg)
                        SELECT Nama_barang, Harga, Stok, Diskon, Gbr_brg FROM barang_deleted";
        if ($conn->query($sql_restore)) {
            $conn->query("DELETE FROM barang_deleted");
            $conn->query("INSERT INTO admin_log (aksi, waktu) VALUES ('Pulihkan semua barang dari recycle bin', NOW())");
            $message = "✅ Semua barang berhasil dipulihkan ke tabel barang.";
        } else {
            $message = "❌ Gagal memulihkan data: " . $conn->error;
        }

    } elseif ($action === "delete_all") {
        $conn->query("DELETE FROM barang_deleted");
        $conn->query("INSERT INTO admin_log (aksi, waktu) VALUES ('Hapus permanen semua barang di recycle bin', NOW())");
        $message = "🗑️ Semua barang di recycle bin telah dihapus permanen.";
    }
}

// Ambil kata pencarian
$search = trim($_POST['search'] ?? '');

// Query pencarian (tidak case-sensitive)
if ($search !== '') {
    $stmt = $conn->prepare("SELECT * FROM barang_deleted WHERE LOWER(Nama_barang) LIKE LOWER(?) ORDER BY no_id DESC");
    $param = "%" . $search . "%";
    $stmt->bind_param("s", $param);
    $stmt->execute();
    $result = $stmt->get_result();
} else {
    $result = $conn->query("SELECT * FROM barang_deleted ORDER BY no_id DESC");
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Recycle Bin - Barang Dihapus</title>
<style>
body {
    font-family: Arial, sans-serif;
    background-color: #f6f8fa;
    padding: 20px;
}
h2 {
    color: #333;
}
form {
    margin-bottom: 15px;
}
table {
    border-collapse: collapse;
    width: 100%;
    background: white;
}
th, td {
    border: 1px solid #ccc;
    padding: 8px;
    text-align: center;
}
th {
    background-color: #f0f0f0;
}
button {
    padding: 8px 16px;
    margin: 5px;
    cursor: pointer;
    border: none;
    border-radius: 4px;
    font-weight: bold;
}
.restore { background-color: #4CAF50; color: white; }
.delete { background-color: #e74c3c; color: white; }
.search-box input[type="text"] {
    width: 250px;
    padding: 6px;
    border-radius: 4px;
    border: 1px solid #ccc;
}
.message {
    background: #fff8e1;
    border-left: 5px solid #ffc107;
    padding: 10px;
    margin-bottom: 15px;
}
</style>
</head>
<body>

<h2>🗑️ Recycle Bin - Barang Dihapus</h2>

<?php if (!empty($message)): ?>
<div class="message"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<form method="post">
    <div class="search-box">
        🔍 <input type="text" name="search" placeholder="Cari nama barang..." value="<?= htmlspecialchars($search) ?>">
        <button type="submit" name="action" value="search">Cari</button>
    </div>
</form>

<?php if ($result && $result->num_rows > 0): ?>
<form method="post" onsubmit="return confirmAction(this);">
    <input type="hidden" name="search" value="<?= htmlspecialchars($search) ?>">
    <table>
        <tr>
            <th>No ID</th>
            <th>Nama Barang</th>
            <th>Harga</th>
            <th>Stok</th>
            <th>Diskon (%)</th>
            <th>Gambar</th>
        </tr>

        <?php while($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= $row['no_id'] ?></td>
            <td><?= htmlspecialchars($row['Nama_barang']) ?></td>
            <td><?= number_format($row['Harga']) ?></td>
            <td><?= $row['Stok'] ?></td>
            <td><?= $row['Diskon'] ?></td>
            <td><img src="gambar/<?= htmlspecialchars($row['Gbr_brg']) ?>" width="80"></td>
        </tr>
        <?php endwhile; ?>
    </table>

    <br>
    <button type="submit" name="action" value="restore_all" class="restore">♻️ Pulihkan Semua</button>
    <button type="submit" name="action" value="delete_all" class="delete">🗑️ Hapus Permanen Semua</button>
</form>

<?php else: ?>
<p>Tidak ada barang di recycle bin <?= $search ? "yang cocok dengan kata '$search'." : "" ?></p>
<?php endif; ?>

<script>
function confirmAction(form) {
    const action = form.querySelector('button[name="action"]:focus')?.value;
    if (action === "restore_all") {
        return confirm("Yakin ingin memulihkan semua barang?");
    } else if (action === "delete_all") {
        return confirm("⚠️ Yakin ingin menghapus permanen SEMUA barang? Tindakan ini tidak bisa dibatalkan!");
    }
    return true;
}
</script>

</body>
</html>
