<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) die("Koneksi gagal: ".$conn->connect_error);

$conn->begin_transaction();

try {
    $result = $conn->query("SELECT * FROM barang_deleted");
    $admin_email = $_SESSION['username'];

    while ($row = $result->fetch_assoc()) {
        // Masukkan ke tabel barang
        $stmt = $conn->prepare("INSERT INTO barang (Nama_barang,Harga,Stok,Diskon,Gbr_brg) VALUES (?,?,?,?,?)");
        $stmt->bind_param("siiis", $row['Nama_barang'],$row['Harga'],$row['Stok'],$row['Diskon'],$row['Gbr_brg']);
        $stmt->execute();
        $stmt->close();

        // Log restore
        $aksi = "Pulihkan semua: ".$row['Nama_barang'];
        $log = $conn->prepare("INSERT INTO admin_log (email_admin, aksi, waktu) VALUES (?,?,NOW())");
        $log->bind_param("ss",$admin_email,$aksi);
        $log->execute();
        $log->close();
    }

    // Hapus semua dari recycle bin
    $conn->query("DELETE FROM barang_deleted");
    $conn->commit();

    echo "<script>alert('Semua barang berhasil dipulihkan!'); window.location='recycle_bin.php';</script>";
} catch (Exception $e) {
    $conn->rollback();
    echo "<script>alert('Gagal: ".$e->getMessage()."'); window.location='recycle_bin.php';</script>";
}

$conn->close();
?>
