<?php

session_start();

include 'db.php';

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}


$pesan = ""; // untuk menampung pesan hasil

if ($_SERVER["REQUEST_METHOD"] === "POST") {

    // Ambil data dari form
    $nama   = trim($_POST['nama'] ?? '');
    $alamat = trim($_POST['alamat'] ?? '');
    $telp   = trim($_POST['telp'] ?? '');

    // Ambil data file upload
    $target_dir = "gambar/";
    $nama_file = basename($_FILES["foto"]["name"]);
    $target_file = $target_dir . $nama_file;
    $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
    $uploadOk = 1;

    if (isset($_FILES["foto"]["tmp_name"]) && $_FILES["foto"]["tmp_name"] != "") {
        $check = getimagesize($_FILES["foto"]["tmp_name"]);
        if ($check === false) {
            $pesan .= "File bukan gambar.<br>";
            $uploadOk = 0;
        }

        if (file_exists($target_file)) {
            $pesan .= "Maaf, file sudah ada.<br>";
            $uploadOk = 0;
        }

        if ($_FILES["foto"]["size"] > 5000000) {
            $pesan .= "Maaf, ukuran file terlalu besar (max 5MB).<br>";
            $uploadOk = 0;
        }

        if (!in_array($imageFileType, ["jpg", "jpeg", "png", "gif"])) {
            $pesan .= "Hanya file JPG, JPEG, PNG & GIF yang diizinkan.<br>";
            $uploadOk = 0;
        }

        if ($uploadOk == 1) {
            if (move_uploaded_file($_FILES["foto"]["tmp_name"], $target_file)) {
                $pesan .= "File <b>" . htmlspecialchars($nama_file) . "</b> berhasil diupload.<br>";

                // Simpan ke database
                $conn = new mysqli($servername, $username, $password, $database);
                if ($conn->connect_error) {
                    die("Koneksi gagal: " . $conn->connect_error);
                }
                
                $stmt = $conn->prepare("SELECT Email FROM pelanggan WHERE Email = ?");
                $stmt->bind_param("s", $_SESSION['username']);
                $stmt->execute();
                $stmt->bind_result($email_baru);
                $stmt->fetch();
                $stmt->close();
                
                if ($email_baru) {
                    echo "Email tersebut sudah terdaftar!";
                } else {
                    
                    $stmt = $conn->prepare("INSERT INTO pelanggan (Nama, Alamat, Email, No_hape, Gbr_plg) VALUES (?, ?, ?, ?, ?)");
                    $stmt->bind_param("sssss", $nama, $alamat, $_SESSION['username'], $telp, $nama_file);

                    if ($stmt->execute()) {
                        $pesan .= "<b>Data pelanggan berhasil disimpan.</b>";
                    } else {
                        $pesan .= "Error database: " . $stmt->error;
                }
                    
                }
                
                $stmt->close();
                $conn->close();
            } else {
                $pesan .= "Maaf, terjadi kesalahan saat mengupload file.<br>";
            }
        }
    } else {
        $pesan .= "Tidak ada file diupload.<br>";
    }
}

?>

<html>
<head>
<meta charset="UTF-8">
<title>Buat Akun</title>
</head>
<body>
<center>
    <font face="verdana" size="6">Buat Akun</font><br>
    <font face="verdana" size="3">(Email tidak bisa diubah. Kalau ingin mengubah, silahkan Buat Login Baru)</font><br>
    <br><br>
    <?php if (!empty($pesan)) echo "<div style='color:blue;font-family:verdana;'>$pesan</div><br>"; ?>
</center>

<form enctype="multipart/form-data" method="post" action="">
    <font face="verdana" size="2">
    <table cellspacing="0" cellpadding="15" border="0" align="center">

        <tr><td>Nama Lengkap</td><td><input type="text" size="50" name="nama" required></td></tr>
        <tr><td>Alamat</td><td><input type="text" size="50" name="alamat" required></td></tr>
        <tr><td>Email</td><td><?php echo $_SESSION['username']; ?></td></tr>
        <tr><td>No. Hape</td><td><input type="text" size="50" name="telp" required></td></tr>
        <tr><td>Photo</td><td><input type="file" size="50" accept="image/*" name="foto" required></td></tr>
        <tr><td></td><td><button type="submit">Simpan</button></td></tr>

    </table>
</form>
</body>
</html>
