<?php

include 'db.php';

// index.php — Halaman utama tanpa login
// Menampilkan etalase barang + diskon

// Koneksi awal untuk ambil logo dan nama toko
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

$stmt = $conn->prepare("SELECT Nama_toko, Gambar_logo FROM logo");
$stmt->execute();
$stmt->bind_result($nama_toko, $logo);
$stmt->fetch();
$stmt->close();
$conn->close();
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title><?= htmlspecialchars($nama_toko) ?></title>
<meta http-equiv="refresh" content="10">
<style>
    body {
        font-family: Verdana, sans-serif;
        background-color: #f8f8f8;
        margin: 0;
        padding: 0;
        color: #333;
    }
    header {
        text-align: center;
        background-color: #ffffff;
        padding: 30px 0;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    }
    header img {
        width: 200px;
        height: auto;
    }
    header .login {
        margin-top: 20px;
    }
    header .login img {
        width: 60px;
        transition: 0.3s;
    }
    header .login img:hover {
        transform: scale(1.1);
    }
    h1 {
        text-align: center;
        margin: 50px 0 20px 0;
        color: #444;
    }
    .etalase {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 25px;
        padding: 20px;
    }
    .card {
        background-color: #fff;
        border-radius: 12px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        width: 220px;
        overflow: hidden;
        transition: 0.3s;
    }
    .card:hover {
        transform: translateY(-5px);
        box-shadow: 0 4px 16px rgba(0,0,0,0.2);
    }
    .card img {
        width: 100%;
        height: 160px;
        object-fit: cover;
        border-bottom: 1px solid #eee;
    }
    .card-content {
        padding: 15px;
    }
    .nama-barang {
        font-size: 16px;
        font-weight: bold;
        margin-bottom: 8px;
    }
    .harga {
        color: #888;
        font-size: 14px;
        margin-bottom: 5px;
    }
    .harga-diskon {
        color: #d9534f;
        font-weight: bold;
        font-size: 15px;
    }
    .stok {
        color: #555;
        font-size: 13px;
    }
    footer {
        text-align: center;
        color: #999;
        padding: 20px;
        font-size: 13px;
    }
</style>
</head>
<body>

<header>
    <img src="gambar/<?= htmlspecialchars($logo) ?>" alt="<?= htmlspecialchars($nama_toko) ?>">
    <div class="login">
        <a href="login.php">
            <img src="gambar/kunci.jpg" alt="Login">
        </a><br>
        <span style="color:#888;">Login</span>
    </div>
</header>

<h1>Etalase <?= htmlspecialchars($nama_toko) ?></h1>

<div class="etalase">
<?php
// Koneksi ke database lagi untuk ambil data barang
$koneksi = new mysqli($servername, $username, $password, $database);
if ($koneksi->connect_error) {
    die("Koneksi gagal: " . $koneksi->connect_error);
}

// Ambil data barang dari tabel barang
$sql = "SELECT Nama_barang, Harga, Stok, Diskon, Gbr_brg FROM barang";
$result = $koneksi->query($sql);

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $harga = (int)$row['Harga'];
        $diskon = (int)$row['Diskon'];
        $harga_setelah_diskon = $harga - ($harga * $diskon / 100);
        echo "
        <div class='card'>
            <img src='gambar/".htmlspecialchars($row['Gbr_brg'])."' alt='".htmlspecialchars($row['Nama_barang'])."'>
            <div class='card-content'>
                <div class='nama-barang'>".htmlspecialchars($row['Nama_barang'])."</div>";
        if ($diskon > 0) {
            echo "<div class='harga'><s>Rp ".number_format($harga, 0, ',', '.')."</s></div>
                  <div class='harga-diskon'>Rp ".number_format($harga_setelah_diskon, 0, ',', '.')." <small>($diskon% off)</small></div>";
        } else {
            echo "<div class='harga-diskon'>Rp ".number_format($harga, 0, ',', '.')."</div>";
        }
        echo "
                <div class='stok'>Stok: {$row['Stok']}</div>
            </div>
        </div>";
    }
} else {
    echo "<p>Belum ada barang.</p>";
}
$koneksi->close();
?>
</div>

<footer>
    &copy; <?= date('Y') ?> <?= htmlspecialchars($nama_toko) ?> — Semua Hak Dilindungi.
</footer>

</body>
</html>
