<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die(json_encode(["error" => "Koneksi gagal: " . $conn->connect_error]));
}

if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST["action"])) {
    $action = $_POST["action"];
    $response = [];

    // 🔍 Pencarian Barang
    if ($action === "search") {
        $cari = strtolower(trim($_POST["brg"] ?? ""));
        $stokFilter = $_POST["stok"] ?? "semua";
        $diskonFilter = $_POST["diskon"] ?? "semua";

        $query = "SELECT Nama_barang, Harga, Stok, Diskon, Gbr_brg FROM barang WHERE LOWER(Nama_barang) LIKE ?";
        $params = ["%" . $cari . "%"];
        $types = "s";

        if ($stokFilter === "habis") {
            $query .= " AND Stok <= 0";
        } elseif ($stokFilter === "tersedia") {
            $query .= " AND Stok > 0";
        }

        if ($diskonFilter === "ada") {
            $query .= " AND Diskon > 0";
        }

        $stmt = $conn->prepare($query);
        $stmt->bind_param($types, ...$params);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows === 0) {
            $response["html"] = "<p style='color:orange;'>Barang tidak ditemukan.</p>";
        } else {
            $html = "<table border='1' cellpadding='8' cellspacing='0' style='border-collapse:collapse;'>
                        <tr style='background-color:#eee;'>
                            <th>Gambar</th><th>Nama Barang</th><th>Harga</th>
                            <th>Stok</th><th>Diskon</th><th>Aksi</th>
                        </tr>";
            while ($row = $result->fetch_assoc()) {
                $stokWarna = $row['Stok'] <= 0 ? "color:red;" : "";
                $html .= "<tr>
                    <td><img src='gambar/" . htmlspecialchars($row['Gbr_brg']) . "' width='60'></td>
                    <td>" . htmlspecialchars($row['Nama_barang']) . "</td>
                    <td>Rp " . number_format($row['Harga'], 0, ',', '.') . "</td>
                    <td style='{$stokWarna}'>" . (int)$row['Stok'] . "</td>
                    <td>" . (int)$row['Diskon'] . " %</td>
                    <td><button class='hapusBtn' data-nama='" . htmlspecialchars($row['Nama_barang']) . "'>🗑️ Hapus</button></td>
                </tr>";
            }
            $html .= "</table>";
            $response["html"] = $html;
        }

        // Tampilkan daftar barang yang sudah dihapus
        $resDel = $conn->query("SELECT Nama_barang, Harga, Diskon, Tanggal_dihapus FROM barang_deleted ORDER BY Tanggal_dihapus DESC LIMIT 5");
        if ($resDel->num_rows > 0) {
            $html2 = "<h4>♻️ Barang Terhapus Terbaru:</h4><table border='1' cellpadding='8' cellspacing='0' style='border-collapse:collapse;'>
                        <tr style='background-color:#eee;'><th>Nama Barang</th><th>Harga</th><th>Diskon</th><th>Tanggal Dihapus</th><th>Aksi</th></tr>";
            while ($r = $resDel->fetch_assoc()) {
                $html2 .= "<tr>
                    <td>" . htmlspecialchars($r['Nama_barang']) . "</td>
                    <td>Rp " . number_format($r['Harga'], 0, ',', '.') . "</td>
                    <td>" . (int)$r['Diskon'] . "%</td>
                    <td>" . $r['Tanggal_dihapus'] . "</td>
                    <td><button class='undoBtn' data-nama='" . htmlspecialchars($r['Nama_barang']) . "'>♻️ UNDO</button></td>
                </tr>";
            }
            $html2 .= "</table>";
            $response["deleted"] = $html2;
        }

        echo json_encode($response);
        exit;
    }

    // ❌ Hapus Barang (pindah ke tabel barang_deleted)
    if ($action === "delete") {
        $nama = trim($_POST["nama"] ?? "");

        // Ambil dulu datanya sebelum dihapus
        $cek = $conn->prepare("SELECT * FROM barang WHERE Nama_barang = ?");
        $cek->bind_param("s", $nama);
        $cek->execute();
        $data = $cek->get_result()->fetch_assoc();

        if ($data) {
            // Simpan ke tabel backup
            $ins = $conn->prepare("INSERT INTO barang_deleted (Nama_barang, Harga, Stok, Diskon, Gbr_brg, Tanggal_dihapus)
                                   VALUES (?, ?, ?, ?, ?, NOW())");
            $ins->bind_param("siiis", $data['Nama_barang'], $data['Harga'], $data['Stok'], $data['Diskon'], $data['Gbr_brg']);
            $ins->execute();

            // Baru hapus dari tabel utama
            $del = $conn->prepare("DELETE FROM barang WHERE Nama_barang = ?");
            $del->bind_param("s", $nama);
            $del->execute();

            $response["message"] = "✅ Barang <b>" . htmlspecialchars($nama) . "</b> dipindahkan ke recycle bin.";
        } else {
            $response["message"] = "⚠️ Barang tidak ditemukan.";
        }

        echo json_encode($response);
        exit;
    }

    // ♻️ UNDO Barang
    if ($action === "undo") {
        $nama = trim($_POST["nama"] ?? "");

        $cek = $conn->prepare("SELECT * FROM barang_deleted WHERE Nama_barang = ?");
        $cek->bind_param("s", $nama);
        $cek->execute();
        $data = $cek->get_result()->fetch_assoc();

        if ($data) {
            // Kembalikan ke tabel utama
            $ins = $conn->prepare("INSERT INTO barang (Nama_barang, Harga, Stok, Diskon, Gbr_brg)
                                   VALUES (?, ?, ?, ?, ?)");
            $ins->bind_param("siiis", $data['Nama_barang'], $data['Harga'], $data['Stok'], $data['Diskon'], $data['Gbr_brg']);
            $ins->execute();

            // Hapus dari tabel recycle bin
            $del = $conn->prepare("DELETE FROM barang_deleted WHERE Nama_barang = ?");
            $del->bind_param("s", $nama);
            $del->execute();

            $response["message"] = "♻️ Barang <b>" . htmlspecialchars($nama) . "</b> telah dikembalikan.";
        } else {
            $response["message"] = "⚠️ Barang tidak ditemukan di recycle bin.";
        }

        echo json_encode($response);
        exit;
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html>
<head>
    <title>🗑️ Hapus Barang + UNDO</title>
    <meta charset="UTF-8">
    <style>
        body { font-family: Arial, sans-serif; margin: 40px; background: #f5f6fa; }
        h2 { color: #2c3e50; }
        input, select, button {
            padding: 8px; border-radius: 6px; border: 1px solid #ccc; margin-right: 8px;
        }
        button { background: #007bff; color: white; cursor: pointer; }
        button:hover { background: #0056b3; }
        .hapusBtn { background: red; }
        .undoBtn { background: green; }
        #hasil, #recycle { margin-top: 25px; }
        table { width: 100%; max-width: 850px; background: white; border-radius: 10px; overflow: hidden; border-collapse: collapse; }
        th, td { text-align: center; border: 1px solid #ccc; padding: 8px; }
        #pesan { margin-top: 15px; font-weight: bold; }
    </style>
</head>
<body>

<h2>🗑️ Hapus Barang + UNDO</h2>

<div>
    <input type="text" id="cari" placeholder="Ketik nama barang...">
    <select id="stok">
        <option value="semua">Stok: Semua</option>
        <option value="habis">Habis</option>
        <option value="tersedia">Tersedia</option>
    </select>
    <select id="diskon">
        <option value="semua">Diskon: Semua</option>
        <option value="ada">Ada Diskon</option>
    </select>
    <button id="tombolCari">Cari</button>
</div>

<div id="pesan"></div>
<div id="hasil"></div>
<div id="recycle"></div>

<script>
function fetchBarang() {
    const brg = document.getElementById('cari').value.trim();
    const stok = document.getElementById('stok').value;
    const diskon = document.getElementById('diskon').value;

    fetch('hapus_brg.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: new URLSearchParams({action: 'search', brg, stok, diskon})
    })
    .then(res => res.json())
    .then(data => {
        document.getElementById('hasil').innerHTML = data.html || "";
        document.getElementById('recycle').innerHTML = data.deleted || "";
        attachEvent();
    });
}

function attachEvent() {
    document.querySelectorAll('.hapusBtn').forEach(btn => {
        btn.addEventListener('click', function() {
            if (confirm(`Yakin ingin hapus ${this.dataset.nama}?`)) {
                fetch('hapus_brg.php', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                    body: new URLSearchParams({action: 'delete', nama: this.dataset.nama})
                })
                .then(res => res.json())
                .then(msg => {
                    document.getElementById('pesan').innerHTML = msg.message;
                    fetchBarang();
                });
            }
        });
    });

    document.querySelectorAll('.undoBtn').forEach(btn => {
        btn.addEventListener('click', function() {
            fetch('hapus_brg.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: new URLSearchParams({action: 'undo', nama: this.dataset.nama})
            })
            .then(res => res.json())
            .then(msg => {
                document.getElementById('pesan').innerHTML = msg.message;
                fetchBarang();
            });
        });
    });
}

document.getElementById('tombolCari').addEventListener('click', fetchBarang);
</script>

</body>
</html>
