<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}


$conn = new mysqli($servername,$username,$password,$database);
if ($conn->connect_error) die("Koneksi gagal: ".$conn->connect_error);

$cari = trim($_POST['cari'] ?? '');
$filter = $_POST['filter'] ?? 'semua';

// --- Build where clause ---
$where = "1=1";
if ($filter==='hari') $where .= " AND DATE(Deleted_at)=CURDATE()";
elseif ($filter==='minggu') $where .= " AND YEARWEEK(Deleted_at,1)=YEARWEEK(CURDATE(),1)";
elseif ($filter==='bulan') $where .= " AND MONTH(Deleted_at)=MONTH(CURDATE()) AND YEAR(Deleted_at)=YEAR(CURDATE())";

if($cari!==''){
    $safe = $conn->real_escape_string($cari);
    $where .= " AND LOWER(Nama_barang) LIKE LOWER('%$safe%')";
}

$result = $conn->query("SELECT * FROM barang_deleted WHERE $where ORDER BY Deleted_at DESC");

// --- Fungsi untuk generate tabel Excel ---
function generateExcelTable($data){
    echo "<table border='1'>";
    echo "<tr><th>Nama Barang</th><th>Harga</th><th>Stok</th><th>Diskon (%)</th><th>Gambar</th><th>Dihapus Pada</th></tr>";
    if($data && $data->num_rows>0){
        while($row=$data->fetch_assoc()){
            echo "<tr>
                    <td>".htmlspecialchars($row['Nama_barang'])."</td>
                    <td>".$row['Harga']."</td>
                    <td>".$row['Stok']."</td>
                    <td>".$row['Diskon']."</td>
                    <td>".$row['Gbr_brg']."</td>
                    <td>".$row['Deleted_at']."</td>
                  </tr>";
        }
    }
    echo "</table>";
}

// --- Header Excel ---
header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=recycle_bin_filtered.xls");
header("Pragma: no-cache");
header("Expires: 0");

// --- Generate tabel ---
generateExcelTable($result);

$conn->close();
?>
