<?php
session_start();

include 'db.php';

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

$conn = new mysqli($servername, $username, $password, $database);
$conn->set_charset("utf8mb4");

if ($conn->connect_error) {
    die("Gagal koneksi: " . $conn->connect_error);
}

$email = trim($_SESSION['username'] ?? '');
if (empty($email)) {
    die("Email pelanggan tidak ditemukan di session.");
}

// --- Ambil no_id pelanggan ---
$stmt = $conn->prepare("SELECT no_id FROM pelanggan WHERE Email = ?");
$stmt->bind_param("s", $email);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows === 0) {
    die("Data pelanggan dengan email ini tidak ada!");
}

$stmt->bind_result($no_plg);
$stmt->fetch();
$stmt->close();

// --- Buat nomor invoice unik ---
do {
    try {
        $randpart = random_int(0, 9999);
    } catch (Exception $e) {
        $randpart = mt_rand(0, 9999);
    }
    $invoice = "INV" . date('Ymd') . sprintf("%04d", $randpart);

    $cek = $conn->prepare("SELECT 1 FROM transaksi WHERE Invoice = ? LIMIT 1");
    $cek->bind_param("s", $invoice);
    $cek->execute();
    $cek->store_result();
    $sudah_ada = $cek->num_rows > 0;
    $cek->close();
} while ($sudah_ada);

// --- Update semua transaksi pelanggan yang belum punya invoice ---
$stmt = $conn->prepare("UPDATE transaksi SET Invoice = ? WHERE no_plg = ? AND (Invoice IS NULL OR Invoice = '')");
$stmt->bind_param("si", $invoice, $no_plg);
$stmt->execute();
$stmt->close();

// --- Hitung total transaksi ---
$sql = "
    SELECT barang.Harga, transaksi.Jumlah_beli 
    FROM transaksi 
    JOIN barang ON transaksi.no_brg = barang.no_id
    WHERE transaksi.no_plg = ? AND transaksi.Invoice = ?
";
$stmt = $conn->prepare($sql);
$stmt->bind_param("is", $no_plg, $invoice);
$stmt->execute();
$result = $stmt->get_result();

$tot_jenderal = 0;
while ($row = $result->fetch_assoc()) {
    $tot_jenderal += $_SESSION['harga_baru'] * $row['Jumlah_beli'];
}
$stmt->close();

// Jika total 0, kembali ke dashboard
if ($tot_jenderal == 0) {
    header("Location: dashboard.php");
    exit;
}

// --- Ambil data rekening ---
$stmt = $conn->prepare("SELECT Nama_bank, No_rek, Atas_nama FROM rekening LIMIT 1");
$stmt->execute();
$stmt->bind_result($nama_bank, $no_rek, $atas_nama);
$stmt->fetch();
$stmt->close();




// --- Ambil email bukti ---
$stmt = $conn->prepare("SELECT Email_bukti FROM bukti LIMIT 1");
$stmt->execute();
$stmt->bind_result($email_resmi);
$stmt->fetch();
$stmt->close();

// --- Ambil ongkos kirim ---
$stmt = $conn->prepare("SELECT Ongkos FROM kirim LIMIT 1");
$stmt->execute();
$stmt->bind_result($ongkos);
$stmt->fetch();
$stmt->close();

$conn->close();
?>


<html>
<head>
    <title>Check Out</title>
</head>
<body>
<center>
    <font face="verdana" size="3">
        Anda Sudah Check Out.<br><br>
        Nomor INVOICE Anda : <b><?php echo htmlspecialchars($invoice); ?></b><br><br>
        Jumlah Total SEMUA yang harus dibayar : 
        Rp. <?php echo number_format($tot_jenderal, 0, ',', '.'); ?><br><br>
        Dengan Ongkos kirim Rp. <?php echo number_format($ongkos, 0, '', '.') ?><br><br>
        Jadi Jumlah yang harus dibayar : 
        <b>Rp. <?php echo number_format($tot_jenderal + $ongkos, 0, ',', '.'); ?></b><br><br><br>
        Silahkan kirim dengan uang tersebut diatas ke:<br><br>
        <?php echo "Nama Bank : " . $nama_bank; ?><br>
        <?php echo "No. Rek : " . $no_rek; ?><br>
        <?php echo "a/n. " . $atas_nama; ?><br><br><br>
        Kirim bukti pembayaran ke Email Kami : <?php echo $email_resmi; ?><br><br><br>
        <a href="dashboard.php"><font face=verdana size=3>[Selesai]</font></a>
    </font>
</center>
</body>
</html>
