<?php
session_start();

include 'db.php';

if ($_SESSION['username'] !== "admin@admin.com") {
    header("Location: login.php");
    exit;
}

$nama_toko = trim($_POST['nama_toko'] ?? '');

// Ambil data file upload
$target_dir = "gambar/";
$nama_file = basename($_FILES["logo_toko"]["name"] ?? '');
$target_file = $target_dir . $nama_file;
$imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
$uploadOk = 1;

// --- Validasi file upload ---
if (isset($_FILES["logo_toko"]["tmp_name"]) && $_FILES["logo_toko"]["tmp_name"] != "") {
    $check = getimagesize($_FILES["logo_toko"]["tmp_name"]);
    if ($check === false) {
        echo "File bukan gambar.<br>";
        $uploadOk = 0;
    }

    if (file_exists($target_file)) {
        echo "Maaf, file sudah ada.<br>";
        $uploadOk = 0;
    }

    if ($_FILES["logo_toko"]["size"] > 5000000) {
        echo "Maaf, ukuran file terlalu besar (max 5MB).<br>";
        $uploadOk = 0;
    }

    if (!in_array($imageFileType, ["jpg", "jpeg", "png", "gif"])) {
        echo "Hanya file JPG, JPEG, PNG & GIF yang diizinkan.<br>";
        $uploadOk = 0;
    }

    // Upload file jika semua valid
    if ($uploadOk == 1) {
        if (move_uploaded_file($_FILES["logo_toko"]["tmp_name"], $target_file)) {
            echo "File " . htmlspecialchars($nama_file) . " berhasil diupload.<br>";
        } else {
            echo "Maaf, terjadi kesalahan saat mengupload file.<br>";
            $uploadOk = 0;
        }
    }
} else {
    echo "Tidak ada file diupload.<br>";
    $uploadOk = 0;
}

// Hanya lanjut simpan ke database kalau upload berhasil
if ($uploadOk == 1) {
    $conn = new mysqli($servername, $username, $password, $database);
    if ($conn->connect_error) {
        die("Koneksi gagal: " . $conn->connect_error);
    }

    $stmt = $conn->prepare("UPDATE logo SET Nama_toko = ?, Gambar_logo = ? WHERE 1");
    $stmt->bind_param("ss", $nama_toko, $nama_file);

    if ($stmt->execute()) {
        echo "<b>Data Toko berhasil disimpan.</b>";
    } else {
        echo "Error: " . $stmt->error;
    }

    $stmt->close();
    $conn->close();
}
?>

<form method="post" enctype="multipart/form-data">
  <table border="0" align="center">
    <tr>
      <td>Nama Toko</td>
      <td><input type="text" name="nama_toko" size="50" required></td>
    </tr>
    <tr><td colspan="2" height="20"></td></tr>
    <tr>
      <td>Logo Toko Online</td>
      <td><input type="file" name="logo_toko" accept="image/*" required></td>
    </tr>
    <tr><td colspan="2" height="20"></td></tr>
    <tr><td colspan="2" align="center">
      <button type="submit" onclick="this.disabled=true; this.form.submit();">Kirim</button>
    </td></tr>
  </table>
</form>
