<?php
session_start();

include 'db.php';

if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

$email = $_SESSION['username'];

$sql = "SELECT 
            transaksi.no_id,
            transaksi.no_brg,
            transaksi.no_plg,
            pelanggan.Email,
            barang.Nama_barang,
            barang.Harga,
            barang.Stok,
            barang.Diskon,
            transaksi.Jumlah_beli,
            transaksi.Invoice
        FROM transaksi
        JOIN barang ON transaksi.no_brg = barang.no_id
        JOIN pelanggan ON transaksi.no_plg = pelanggan.no_id
        WHERE pelanggan.Email = ? AND transaksi.Invoice IS NULL";

$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

$tot_jenderal = 0;
$no_plg = null;

while ($row = $result->fetch_assoc()) {
    $harga = (float)$row['Harga'];
    $diskon = (float)$row['Diskon'];
    $jumlah = (int)$row['Jumlah_beli'];

    // Hitung harga setelah diskon jika ada
    if ($diskon > 0) {
        $harga_baru = $harga - ($harga * ($diskon / 100));
    } else {
        $harga_baru = $harga;
    }

    $tot_jenderal += $jumlah * $harga_baru;
    $no_plg = $row['no_plg'];
}

$stmt->close();

if ($no_plg === null) {
    echo "Tidak ada transaksi yang bisa di-checkout.";
    exit;
}

if ($tot_jenderal == 0) {
    echo "Anda belum membeli apa-apa.";
    exit;
}

$_SESSION['tot_jenderal'] = $tot_jenderal;
$_SESSION['no_plg'] = $no_plg;

// Buat nomor invoice unik
do {
    try {
        $randpart = random_int(0, 9999);
    } catch (Exception $e) {
        $randpart = mt_rand(0, 9999);
    }

    $invoice = "INV" . date('Ymd') . sprintf("%04d", $randpart);

    $cek = $conn->prepare("SELECT 1 FROM transaksi WHERE Invoice = ? LIMIT 1");
    $cek->bind_param("s", $invoice);
    $cek->execute();
    $cek->store_result();
    $sudah_ada = $cek->num_rows > 0;
    $cek->close();
} while ($sudah_ada);

$update = $conn->prepare("UPDATE transaksi SET Invoice = ? WHERE no_plg = ? AND Invoice IS NULL");
$update->bind_param("si", $invoice, $no_plg);
$update->execute();
$berhasil = $update->affected_rows > 0;
$update->close();

if (!$berhasil) {
    echo "Gagal membuat invoice. Mungkin transaksi sudah di-checkout sebelumnya.";
    exit;
}

// Ambil data rekening
$stmt = $conn->prepare("SELECT Nama_bank, No_rek, Atas_nama FROM rekening LIMIT 1");
$stmt->execute();
$stmt->bind_result($nama_bank, $no_rek, $atas_nama);
$stmt->fetch();
$stmt->close();

// Ambil email bukti
$stmt = $conn->prepare("SELECT Email_bukti FROM bukti LIMIT 1");
$stmt->execute();
$stmt->bind_result($email_resmi);
$stmt->fetch();
$stmt->close();

// Ambil ongkos kirim
$stmt = $conn->prepare("SELECT Ongkos FROM kirim LIMIT 1");
$stmt->execute();
$stmt->bind_result($ongkos);
$stmt->fetch();
$stmt->close();

$conn->close();
?>
<!DOCTYPE html>
<html>
<head>
    <title>Check Out</title>
</head>
<body>
<center>
    <font face="verdana" size="3">
        Anda Sudah Check Out.<br><br>
        Nomor INVOICE Anda : <b><?php echo htmlspecialchars($invoice); ?></b><br><br>
        Jumlah Total SEMUA yang harus dibayar : 
        Rp. <?php echo number_format($tot_jenderal, 0, ',', '.'); ?><br><br>
        Dengan Ongkos kirim Rp. <?php echo number_format($ongkos, 0, ',', '.'); ?><br><br>
        Jadi Jumlah yang harus dibayar : 
        <b>Rp. <?php echo number_format($tot_jenderal + $ongkos, 0, ',', '.'); ?></b><br><br><br>
        Silahkan kirim uang tersebut ke:<br><br>
        Nama Bank: <?php echo htmlspecialchars($nama_bank); ?><br>
        No. Rek: <?php echo htmlspecialchars($no_rek); ?><br>
        a/n: <?php echo htmlspecialchars($atas_nama); ?><br><br><br>
        Kirim bukti pembayaran ke Email Kami: <?php echo htmlspecialchars($email_resmi); ?><br><br><br>
        <a href="dashboard.php"><font face=verdana size=3>[Selesai]</font></a>
    </font>
</center>
</body>
</html>
