<?php
session_start();
include 'db.php';

// Cek login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

$kasir = $_SESSION['username'];
$no_trans = "TRX" . date("YmdHis");
$tanggal = date("Y-m-d H:i:s");
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Transaksi Penjualan - POS Mini Market</title>
<style>
body {
    font-family: Verdana;
    background: #f2f2f2;
    padding: 20px;
}
h2 {
    color: #333;
    text-align: center;
}
.table-box {
    background: #fff;
    padding: 15px;
    border-radius: 10px;
    box-shadow: 0 0 10px rgba(0,0,0,0.1);
}
table {
    border-collapse: collapse;
    width: 100%;
}
th, td {
    border: 1px solid #ccc;
    padding: 8px;
    text-align: center;
}
th {
    background-color: #efefef;
}
input[type=text], input[type=number] {
    width: 100%;
    border: none;
    text-align: center;
    background: transparent;
    outline: none;
}
button {
    padding: 8px 15px;
    background: #4CAF50;
    border: none;
    color: white;
    font-weight: bold;
    border-radius: 5px;
    cursor: pointer;
}
button:hover { background: #45a049; }
.total-box {
    margin-top: 15px;
    text-align: right;
    font-size: 18px;
    font-weight: bold;
}
input[readonly] {
    background: #f9f9f9;
}
</style>

<script>
function tambahBaris() {
    let table = document.getElementById("tabelBarang");
    let row = table.insertRow(-1);
    row.innerHTML = `
        <td><input type="text" name="barkode[]" placeholder="Ketik barkode" onblur="ambilDataBarang(this)"></td>
        <td><input type="text" name="nama_barang[]" readonly></td>
        <td><input type="number" name="harga[]" readonly></td>
        <td><input type="number" name="jumlah[]" value="1" min="1" onchange="hitungSubtotal(this)"></td>
        <td><input type="number" name="subtotal[]" value="0" readonly></td>
        <td><button type="button" onclick="hapusBaris(this)">X</button></td>
    `;
}

function hapusBaris(btn) {
    btn.closest("tr").remove();
    hitungTotal();
}

function ambilDataBarang(input) {
    const barkode = input.value.trim();
    if (barkode === '') return;

    fetch("get_barang.php?barkode=" + barkode)
    .then(res => res.json())
    .then(data => {
        if (data.status === "ok") {
            const row = input.closest("tr");
            row.querySelector('input[name="nama_barang[]"]').value = data.nama_barang;
            row.querySelector('input[name="harga[]"]').value = data.harga;
            row.querySelector('input[name="jumlah[]"]').focus();
            hitungSubtotal(row.querySelector('input[name="jumlah[]"]'));
        } else {
            alert("Barang tidak ditemukan!");
            input.focus();
        }
    });
}

function hitungSubtotal(el) {
    const row = el.closest("tr");
    const harga = parseInt(row.querySelector('input[name="harga[]"]').value || 0);
    const jumlah = parseInt(row.querySelector('input[name="jumlah[]"]').value || 0);
    const subtotal = harga * jumlah;
    row.querySelector('input[name="subtotal[]"]').value = subtotal;
    hitungTotal();
}

function hitungTotal() {
    let total = 0;
    document.querySelectorAll('input[name="subtotal[]"]').forEach(el => {
        total += parseInt(el.value || 0);
    });
    document.getElementById("totalBayar").innerText = "Total: Rp " + total.toLocaleString();
    document.getElementById("totalHidden").value = total;
}

function hitungKembalian() {
    const total = parseInt(document.getElementById("totalHidden").value || 0);
    const dibayar = parseInt(document.getElementById("dibayar").value || 0);
    const kembali = dibayar - total;
    document.getElementById("kembalian").value = kembali > 0 ? kembali : 0;
}
</script>
</head>

<body>
<h2>🛒 Transaksi Penjualan</h2>

<div class="table-box">
<form method="post" action="simpan_transaksi.php">
<p>
<b>No. Transaksi:</b> <?= $no_trans ?><br>
<b>Tanggal:</b> <?= $tanggal ?><br>
<b>Kasir:</b> <?= htmlspecialchars($kasir) ?><br>
</p>

<table id="tabelBarang">
    <tr>
        <th>Barkode</th>
        <th>Nama Barang</th>
        <th>Harga</th>
        <th>Jumlah</th>
        <th>Subtotal</th>
        <th>Aksi</th>
    </tr>
    <tr>
        <td><input type="text" name="barkode[]" placeholder="Ketik barkode" onblur="ambilDataBarang(this)"></td>
        <td><input type="text" name="nama_barang[]" readonly></td>
        <td><input type="number" name="harga[]" readonly></td>
        <td><input type="number" name="jumlah[]" value="1" min="1" onchange="hitungSubtotal(this)"></td>
        <td><input type="number" name="subtotal[]" value="0" readonly></td>
        <td><button type="button" onclick="hapusBaris(this)">X</button></td>
    </tr>
</table>

<div class="total-box" id="totalBayar">Total: Rp 0</div>

<br>
<label>Uang Dibayar: Rp </label>
<input type="number" id="dibayar" name="dibayar" onkeyup="hitungKembalian()" required>
<br><br>
<label>Kembalian: Rp </label>
<input type="number" id="kembalian" readonly>
<input type="hidden" name="no_trans" value="<?= $no_trans ?>">
<input type="hidden" name="kasir" value="<?= htmlspecialchars($kasir) ?>">
<input type="hidden" name="total_bayar" id="totalHidden">

<br><br>
<button type="button" onclick="tambahBaris()">+ Tambah Barang</button>
<button type="submit">💾 Simpan Transaksi</button>
</form>
</div>
</body>
</html>
