<?php
session_start();
include 'db.php';

// 🔒 Cek login
if (!isset($_SESSION['username'])) {
    header("Location: index.php");
    exit;
}

$pesan = "";

// === SIMPAN BARANG BARU ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['simpan'])) {
    $barkode      = trim($_POST['barkode']);
    $nama_barang  = trim($_POST['nama_barang']);
    $harga_beli   = (int) $_POST['harga_beli'];
    $harga_jual   = (int) $_POST['harga_jual'];
    $stok         = (int) $_POST['stok'];
    $tanpa_exp    = isset($_POST['tanpa_exp']) ? 1 : 0;
    $kadaluwarsa  = !$tanpa_exp ? ($_POST['tgl'] ?? null) : null;

    if ($barkode === '' || $nama_barang === '' || $harga_beli <= 0 || $harga_jual <= 0) {
        $pesan = "<p class='error'>❌ Semua field wajib diisi dengan benar!</p>";
    } else {
        $cek = $conn->prepare("SELECT barkode FROM barang WHERE barkode = ?");
        $cek->bind_param("s", $barkode);
        $cek->execute();
        $cek->store_result();

        if ($cek->num_rows > 0) {
            $pesan = "<p class='error'>⚠️ Barcode <b>" . htmlspecialchars($barkode) . "</b> sudah terdaftar!</p>";
        } else {
            if ($tanpa_exp) {
                $stmt = $conn->prepare("INSERT INTO barang (barkode, nama_barang, harga_beli, harga, stok, kadaluwarsa) 
                                        VALUES (?, ?, ?, ?, ?, NULL)");
                $stmt->bind_param("ssiii", $barkode, $nama_barang, $harga_beli, $harga_jual, $stok);
            } else {
                $stmt = $conn->prepare("INSERT INTO barang (barkode, nama_barang, harga_beli, harga, stok, kadaluwarsa) 
                                        VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->bind_param("ssiiis", $barkode, $nama_barang, $harga_beli, $harga_jual, $stok, $kadaluwarsa);
            }

            if ($stmt->execute()) {
                $pesan = "<p class='success'>✅ Data barang berhasil disimpan!</p>";
            } else {
                $pesan = "<p class='error'>❌ Data barang gagal disimpan!</p>";
            }
            $stmt->close();
        }
        $cek->close();
    }
}

// === HAPUS BARANG ===
if (isset($_GET['hapus'])) {
    $hapus = $_GET['hapus'];
    $stmt = $conn->prepare("DELETE FROM barang WHERE barkode = ?");
    $stmt->bind_param("s", $hapus);
    if ($stmt->execute()) {
        $pesan = "<p class='success'>🗑️ Data barang dengan kode <b>" . htmlspecialchars($hapus) . "</b> berhasil dihapus!</p>";
    } else {
        $pesan = "<p class='error'>❌ Gagal menghapus data!</p>";
    }
    $stmt->close();
}

// === TAMPILKAN SEMUA BARANG ===
$result = $conn->query("SELECT barkode, nama_barang, harga_beli, harga, stok, kadaluwarsa FROM barang ORDER BY nama_barang ASC");
?>
<!DOCTYPE html>
<html>
<head>
<title>Tambah & Daftar Barang</title>
<style>
body {
    font-family: Verdana;
    background-color: #f8fafc;
}
h1 { color: #222; }
form {
    background: #ffffff;
    padding: 25px;
    border-radius: 12px;
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    width: 420px;
}
input[type=text], input[type=number], input[type=date] {
    width: 100%;
    padding: 8px;
    margin-top: 4px;
    margin-bottom: 10px;
    border: 1px solid #ccc;
    border-radius: 8px;
}
input[type=submit] {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 10px 25px;
    border-radius: 8px;
    cursor: pointer;
}
input[type=submit]:hover {
    background-color: #0056b3;
}
a {
    text-decoration: none;
    color: #007bff;
}
table {
    border-collapse: collapse;
    width: 90%;
    margin-top: 25px;
    background: #fff;
    box-shadow: 0 2px 6px rgba(0,0,0,0.1);
}
th, td {
    border: 1px solid #ccc;
    padding: 8px;
    text-align: center;
}
th {
    background-color: #007bff;
    color: white;
}
.success { color: green; font-weight: bold; }
.error { color: red; font-weight: bold; }
.checkbox-container {
    margin-top: 5px;
    margin-bottom: 15px;
}
.btn-hapus {
    color: red;
    text-decoration: none;
    font-weight: bold;
}
.btn-edit {
    color: green;
    text-decoration: none;
    font-weight: bold;
}
</style>
<script>
function toggleTanggal() {
    const checkbox = document.getElementById('tanpa_exp');
    const tgl = document.getElementById('tgl');
    tgl.disabled = checkbox.checked;
    if (checkbox.checked) tgl.value = "";
}
function confirmDelete(barkode) {
    return confirm("Yakin ingin menghapus barang dengan kode " + barkode + "?");
}
</script>
</head>

<body>
<center>
    <h1>🛒 Tambah Data Barang</h1>
    <div><?= $pesan ?></div>
    <form method="post">
        <label>Barcode:</label><br>
        <input type="text" name="barkode" required><br>

        <label>Nama Barang:</label><br>
        <input type="text" name="nama_barang" required><br>

        <label>Harga Beli:</label><br>
        <input type="number" name="harga_beli" min="1" required><br>

        <label>Harga Jual:</label><br>
        <input type="number" name="harga_jual" min="1" required><br>

        <label>Stok Barang:</label><br>
        <input type="number" name="stok" min="0" required><br>

        <label>Tanggal Kadaluwarsa:</label><br>
        <input type="date" id="tgl" name="tgl"><br>

        <div class="checkbox-container">
            <input type="checkbox" id="tanpa_exp" name="tanpa_exp" onclick="toggleTanggal()">
            <label for="tanpa_exp">Barang tidak memiliki tanggal kadaluwarsa</label>
        </div>

        <input type="submit" name="simpan" value="Simpan Barang">
    </form>

    <h2>📋 Daftar Barang</h2>
    <table>
        <tr>
            <th>Barcode</th>
            <th>Nama Barang</th>
            <th>Harga Beli</th>
            <th>Harga Jual</th>
            <th>Stok</th>
            <th>Kadaluwarsa</th>
            <th>Aksi</th>
        </tr>
        <?php while($row = $result->fetch_assoc()): ?>
        <tr>
            <td><?= htmlspecialchars($row['barkode']) ?></td>
            <td><?= htmlspecialchars($row['nama_barang']) ?></td>
            <td><?= number_format($row['harga_beli']) ?></td>
            <td><?= number_format($row['harga']) ?></td>
            <td><?= htmlspecialchars($row['stok']) ?></td>
            <td><?= $row['kadaluwarsa'] ? htmlspecialchars($row['kadaluwarsa']) : '-' ?></td>
            <td>
                <a href="edit_barang.php?barkode=<?= urlencode($row['barkode']) ?>" class="btn-edit">✏️ Edit</a> |
                <a href="?hapus=<?= urlencode($row['barkode']) ?>" class="btn-hapus" onclick="return confirmDelete('<?= htmlspecialchars($row['barkode']) ?>')">🗑️ Hapus</a>
            </td>
        </tr>
        <?php endwhile; ?>
    </table>

    <br>
    <a href="dashboard.php">⬅️ Kembali ke Dashboard</a>
</center>
</body>
</html>
<?php $conn->close(); ?>
