<?php
session_start();
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Ambil input & bersihkan
    $username = trim($_POST['username'] ?? '');
    $sandi    = trim($_POST['sandi'] ?? '');

    if ($username === '' || $sandi === '') {
        echo "<p style='color:red;'>⚠️ Username dan password wajib diisi.</p>";
    } else {
        // Siapkan query
        $stmt = $conn->prepare("SELECT username, password FROM operator WHERE username = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $stmt->bind_result($user, $hashed);
            $stmt->fetch();

            if (password_verify($sandi, $hashed)) {
                // Login berhasil
                $_SESSION['username'] = $user;
                header("Location: dashboard.php");
                exit;
            } else {
                echo "<p style='color:red;'>❌ Password salah. Silakan ulangi.</p>";
            }
        } else {
            echo "<p style='color:red;'>❌ Username tidak ditemukan.</p>";
        }

        $stmt->close();
    }

    $conn->close();
}
?>
<!DOCTYPE html>
<html>
<head>
<title>Login</title>
<style>
body {
    font-family: Verdana;
    background: linear-gradient(135deg, #0088cc, #00b3b3);
    color: white;
}
form {
    background: white;
    color: black;
    width: 350px;
    margin-top: 100px;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0 0 10px #00000055;
}
input[type=text], input[type=password] {
    width: 100%;
    padding: 10px;
    margin: 5px 0;
    border-radius: 8px;
    border: 1px solid #aaa;
}
input[type=submit] {
    width: 100%;
    padding: 10px;
    background-color: #00b3b3;
    color: white;
    border: none;
    border-radius: 8px;
    cursor: pointer;
}
input[type=submit]:hover {
    background-color: #0088cc;
}
</style>
</head>
<body>
<center>
    <form method="post">
        <h2>🔐 Login Operator</h2>
        <label>Username:</label><br>
        <input type="text" name="username" required><br><br>
        <label>Password:</label><br>
        <input type="password" name="sandi" required><br><br>
        <input type="submit" value="Login">
    </form>
</center>
</body>
</html>
