<?php
session_start();
include 'db.php';

// Hanya admin 'boss' yang boleh
if ($_SESSION['username'] !== 'boss') {
   header("Location: index.php");
   exit;
}

// Koneksi database
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
   die("Koneksi gagal: " . $conn->connect_error);
}

// Jika tombol konfirmasi ditekan
if (isset($_POST['hapus'])) {

    // Nonaktifkan foreign key constraint sementara
    $conn->query("SET FOREIGN_KEY_CHECKS=0");

    $ok1 = $conn->query("TRUNCATE TABLE detail_transaksi");
    $ok2 = $conn->query("TRUNCATE TABLE transaksi");

    $conn->query("SET FOREIGN_KEY_CHECKS=1");

    if ($ok1 && $ok2) {
        echo "<p style='color:green; font-family:verdana;'>✅ Semua data transaksi & detail transaksi berhasil dihapus!</p>";
    } else {
        echo "<p style='color:red; font-family:verdana;'>❌ Gagal menghapus data transaksi.</p>";
    }

    echo "<a href='dashboard.php'>⬅️ Kembali ke Dashboard</a>";

} else {
?>
<!DOCTYPE html>
<html>
<head>
   <title>Hapus Semua Transaksi</title>
</head>
<body style="font-family:verdana; background-color:#f2f2f2; text-align:center; margin-top:100px;">
   <div style="background:white; padding:30px; border-radius:10px; display:inline-block; box-shadow:0 0 10px #999;">
       <h2>⚠️ Konfirmasi Penghapusan</h2>
       <p>Apakah Anda yakin ingin menghapus <b>semua data transaksi</b> dan <b>detail transaksi</b>?</p>
       <p style="color:red;">Tindakan ini tidak dapat dibatalkan!</p>

       <form method="post">
           <input type="submit" name="hapus" value="Ya, Hapus Semua" 
              style="background:red; color:white; border:none; padding:10px 20px; border-radius:5px; cursor:pointer;">
           <a href="dashboard.php" 
              style="background:gray; color:white; text-decoration:none; padding:10px 20px; border-radius:5px; margin-left:10px;">Batal</a>
       </form>
   </div>
</body>
</html>
<?php
}
$conn->close();
?>
