<?php
session_start();
include 'db.php';
error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['username'])) {
    header("Location: index.php");
    exit;
}


?>

<html>
<head>
<title>Laporan Keuntungan Penjualan</title>
<style>
body {
    font-family: Verdana, sans-serif;
    background-color: #f8f8f8;
    color: #333;
}
h2 { text-align: center; }
form { text-align: center; margin-bottom: 20px; }
table { margin: auto; border-collapse: collapse; }
td, th { border: 1px solid #ccc; padding: 8px 12px; background-color: #fff; }
th { background-color: #e0e0e0; }
.summary { margin-top: 20px; text-align: center; font-size: 18px; }
input[type="date"], input[type="submit"], button {
    padding: 6px 12px;
    font-size: 14px;
    border-radius: 5px;
    border: none;
}
input[type="submit"], button {
    background-color: #007BFF;
    color: white;
    cursor: pointer;
}
input[type="submit"]:hover, button:hover {
    background-color: #0056b3;
}
button.export {
    margin: 10px 5px;
    background-color: #28a745;
}
button.export:hover {
    background-color: #1e7e34;
}
</style>
</head>
<body>

<h2>📊 Laporan Keuntungan Penjualan</h2>

<form method="post">
    Dari: <input type="date" name="tgl1" required>
    &nbsp;&nbsp;
    Sampai: <input type="date" name="tgl2" required>
    &nbsp;&nbsp;
    <input type="submit" name="tampilkan" value="Tampilkan">
</form>

<?php
if (isset($_POST['tampilkan'])) {
    $tgl1 = $_POST['tgl1'];
    $tgl2 = $_POST['tgl2'];

    // ✅ Ambil tanggal dari tabel transaksi
    $sql = "
    SELECT 
      t.tanggal,
      dt.id_transaksi,
      dt.nama_barang,
      b.harga_beli,
      dt.harga AS harga_jual,
      dt.jumlah,
      dt.subtotal
    FROM detail_transaksi AS dt
    JOIN barang AS b ON dt.barkode = b.barkode
    JOIN transaksi AS t ON dt.id_transaksi = t.id_transaksi
    WHERE DATE(t.tanggal) BETWEEN ? AND ?
    ORDER BY t.tanggal DESC
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $tgl1, $tgl2);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        echo "<p style='text-align:center;color:red;'>Tidak ada transaksi pada periode tersebut.</p>";
    } else {
        echo "<table>
        <tr>
        <th>Tanggal</th>
        <th>No.Trans</th>
        <th>Nama Barang</th>
        <th>Harga Beli</th>
        <th>Harga Jual</th>
        <th>Jumlah</th>
        <th>Subtotal</th>
        </tr>";

        $total = 0;
        $modal = 0;

        while ($row = $result->fetch_assoc()) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($row['tanggal']) . "</td>";
            echo "<td align=center>" . htmlspecialchars($row['id_transaksi']) . "</td>";
            echo "<td>" . htmlspecialchars($row['nama_barang']) . "</td>";
            echo "<td align=right>" . number_format($row['harga_beli'], 0, ',', '.') . "</td>";
            echo "<td align=right>" . number_format($row['harga_jual'], 0, ',', '.') . "</td>";
            echo "<td align=center>" . $row['jumlah'] . "</td>";
            echo "<td align=right>" . number_format($row['subtotal'], 0, ',', '.') . "</td>";
            echo "</tr>";

            $total += $row['subtotal'];
            $modal += $row['harga_beli'] * $row['jumlah'];
        }

        $keuntungan = $total - $modal;

        echo "</table>";
        echo "<div class='summary'>
        <br><b>Total Penjualan:</b> Rp " . number_format($total, 0, ',', '.') . "<br>
        <b>Total Modal:</b> Rp " . number_format($modal, 0, ',', '.') . "<br>
        <b>Keuntungan Bersih:</b> Rp " . number_format($keuntungan, 0, ',', '.') . "
        </div>";

        // 🟢 Tombol Ekspor
        echo "
        <div style='text-align:center; margin-top:25px;'>
            <form method='post' action='export_excel.php' style='display:inline;'>
                <input type='hidden' name='tgl1' value='$tgl1'>
                <input type='hidden' name='tgl2' value='$tgl2'>
                <button type='submit' class='export'>📗 Ekspor ke Excel</button>
            </form>
            <form method='post' action='export_pdf.php' style='display:inline;'>
                <input type='hidden' name='tgl1' value='$tgl1'>
                <input type='hidden' name='tgl2' value='$tgl2'>
                <button type='submit' class='export'>📄 Ekspor ke PDF</button>
            </form>
        </div>";
    }

    $stmt->close();
}
$conn->close();
?>
</body>
</html>
