<?php
// isi file : kadaluwarsa.php

session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
    header("Location: index.php");
    exit;
}

// koneksi database
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . htmlspecialchars($conn->connect_error));
}

$result = $conn->query("SELECT nama_barang, kadaluwarsa FROM barang");
$hari_ini = date('Y-m-d');
?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Status Kadaluwarsa Barang</title>
<style>
body {
  font-family: Verdana, sans-serif;
  background: linear-gradient(135deg, #f0f0f0, #cce7ff);
  margin: 0;
  padding: 0;
}
.container {
  max-width: 900px;
  margin: 50px auto;
  background: #fff;
  padding: 30px;
  border-radius: 15px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}
h2 {
  text-align: center;
  color: #333;
  margin-bottom: 20px;
}
table {
  width: 100%;
  border-collapse: collapse;
}
th, td {
  padding: 12px;
  text-align: center;
  border-bottom: 1px solid #ccc;
}
th {
  background-color: #007bff;
  color: white;
}
.status {
  font-weight: bold;
  padding: 8px 12px;
  border-radius: 8px;
  display: inline-block;
}
.sudah {
  background-color: #ffb3b3;
  color: #c00;
}
.hariini {
  background-color: #ffe680;
  color: #a66d00;
}
.aktif {
  background-color: #c6f6c6;
  color: #008000;
}
footer {
  text-align: center;
  margin-top: 30px;
  color: #666;
  font-size: 13px;
}
</style>
</head>
<body>
<div class="container">
  <h2>📅 Daftar Status Kadaluwarsa Barang</h2>
  <table>
    <tr>
      <th>Nama Barang</th>
      <th>Tanggal Kadaluwarsa</th>
      <th>Status</th>
    </tr>
<?php
while ($row = $result->fetch_assoc()) {
    $exp = $row['kadaluwarsa'];
    if ($exp < $hari_ini) {
        $status = "<span class='status sudah'>❌ Sudah Kadaluarsa</span>";
    } elseif ($exp == $hari_ini) {
        $status = "<span class='status hariini'>⚠️ Kadaluarsa Hari Ini!</span>";
    } else {
        $status = "<span class='status aktif'>✅ Masih Berlaku</span>";
    }
    
    if ($row['kadaluwarsa'] == NULL) {
        $status = "<span class='status aktif'>✅ Masih Berlaku</span>";
    }

    echo "<tr>";
    echo "<td>" . htmlspecialchars($row['nama_barang']) . "</td>";
    echo "<td>" . htmlspecialchars($exp) . "</td>";
    echo "<td>" . $status . "</td>";
    echo "</tr>";
}
?>
  </table>
  <footer>© <?= date('Y') ?> - Sistem POS | Status Kadaluarsa Barang</footer>
</div>
</body>
</html>
<?php
$conn->close();
?>
