<?php
session_start();
require('fpdf.php');
include 'db.php';


if (!isset($_SESSION['username'])) {
    header("Location: index.php");
    exit;
}



$tgl1 = $_POST['tgl1'];
$tgl2 = $_POST['tgl2'];

class PDF extends FPDF {
    function Header() {
        $this->SetFont('Arial','B',14);
        $this->Cell(0,10,'Laporan Keuntungan Penjualan',0,1,'C');
        $this->Ln(5);
    }
}

$pdf = new PDF('P','mm','A4');
$pdf->AddPage();
$pdf->SetFont('Arial','',11);

$pdf->Cell(0,10,"Periode: $tgl1 s/d $tgl2",0,1,'C');
$pdf->Ln(5);

$pdf->SetFont('Arial','B',10);
$pdf->Cell(25,8,'Tanggal',1);
$pdf->Cell(25,8,'No.Trans',1);
$pdf->Cell(50,8,'Nama Barang',1);
$pdf->Cell(25,8,'Hrg Beli',1);
$pdf->Cell(25,8,'Hrg Jual',1);
$pdf->Cell(15,8,'Jml',1);
$pdf->Cell(25,8,'Subtotal',1);
$pdf->Ln();

$pdf->SetFont('Arial','',9);

$sql = "
SELECT 
  t.tanggal,
  dt.id_transaksi,
  dt.nama_barang,
  b.harga_beli,
  dt.harga AS harga_jual,
  dt.jumlah,
  dt.subtotal
FROM detail_transaksi AS dt
JOIN barang AS b ON dt.barkode = b.barkode
JOIN transaksi AS t ON dt.id_transaksi = t.id_transaksi
WHERE DATE(t.tanggal) BETWEEN '$tgl1' AND '$tgl2'
ORDER BY t.tanggal DESC
";

$result = $conn->query($sql);

$total = 0;
$modal = 0;

while ($row = $result->fetch_assoc()) {
    $pdf->Cell(25,7,$row['tanggal'],1);
    $pdf->Cell(25,7,$row['id_transaksi'],1);
    $pdf->Cell(50,7,substr($row['nama_barang'],0,25),1);
    $pdf->Cell(25,7,number_format($row['harga_beli'],0,',','.'),1,0,'R');
    $pdf->Cell(25,7,number_format($row['harga_jual'],0,',','.'),1,0,'R');
    $pdf->Cell(15,7,$row['jumlah'],1,0,'C');
    $pdf->Cell(25,7,number_format($row['subtotal'],0,',','.'),1,0,'R');
    $pdf->Ln();

    $total += $row['subtotal'];
    $modal += $row['harga_beli'] * $row['jumlah'];
}

$keuntungan = $total - $modal;

$pdf->Ln(5);
$pdf->SetFont('Arial','B',10);
$pdf->Cell(0,8,"Total Penjualan: Rp " . number_format($total,0,',','.'),0,1);
$pdf->Cell(0,8,"Total Modal: Rp " . number_format($modal,0,',','.'),0,1);
$pdf->Cell(0,8,"Keuntungan Bersih: Rp " . number_format($keuntungan,0,',','.'),0,1);

$pdf->Output("I","Laporan_Keuntungan_{$tgl1}_sd_{$tgl2}.pdf");

$conn->close();
?>
