<?php
session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
    header("Location: index.php");
    exit;
}


$tgl1 = $_POST['tgl1'];
$tgl2 = $_POST['tgl2'];

header("Content-Type: application/vnd.ms-excel");
header("Content-Disposition: attachment; filename=Laporan_Keuntungan_{$tgl1}_sd_{$tgl2}.xls");

echo "<h3>Laporan Keuntungan Penjualan</h3>";
echo "<p>Periode: $tgl1 s/d $tgl2</p>";

echo "<table border='1'>
<tr>
<th>Tanggal</th>
<th>No.Trans</th>
<th>Nama Barang</th>
<th>Harga Beli</th>
<th>Harga Jual</th>
<th>Jumlah</th>
<th>Subtotal</th>
</tr>";

$sql = "
SELECT 
  t.tanggal,
  dt.id_transaksi,
  dt.nama_barang,
  b.harga_beli,
  dt.harga AS harga_jual,
  dt.jumlah,
  dt.subtotal
FROM detail_transaksi AS dt
JOIN barang AS b ON dt.barkode = b.barkode
JOIN transaksi AS t ON dt.id_transaksi = t.id_transaksi
WHERE DATE(t.tanggal) BETWEEN '$tgl1' AND '$tgl2'
ORDER BY t.tanggal DESC
";

$result = $conn->query($sql);

$total = 0;
$modal = 0;

while ($row = $result->fetch_assoc()) {
    echo "<tr>
    <td>{$row['tanggal']}</td>
    <td>{$row['id_transaksi']}</td>
    <td>{$row['nama_barang']}</td>
    <td align=right>{$row['harga_beli']}</td>
    <td align=right>{$row['harga_jual']}</td>
    <td align=center>{$row['jumlah']}</td>
    <td align=right>{$row['subtotal']}</td>
    </tr>";

    $total += $row['subtotal'];
    $modal += $row['harga_beli'] * $row['jumlah'];
}

$keuntungan = $total - $modal;

echo "<tr><td colspan='6'><b>Total Penjualan</b></td><td align=right><b>$total</b></td></tr>";
echo "<tr><td colspan='6'><b>Total Modal</b></td><td align=right><b>$modal</b></td></tr>";
echo "<tr><td colspan='6'><b>Keuntungan Bersih</b></td><td align=right><b>$keuntungan</b></td></tr>";

echo "</table>";

$conn->close();
?>
