<?php
session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
    header("Location: index.php");
    exit;
}

$pesan = "";
$barkode = $_GET['barkode'] ?? '';

if ($barkode === '') {
    die("Kode barang tidak ditemukan!");
}

// === Ambil data barang berdasarkan barkode ===
$stmt = $conn->prepare("SELECT barkode, nama_barang, harga_beli, harga, stok, kadaluwarsa 
                        FROM barang WHERE barkode = ?");
$stmt->bind_param("s", $barkode);
$stmt->execute();
$stmt->bind_result($barkode, $nama_barang, $harga_beli, $harga_jual, $stok, $kadaluwarsa);
$stmt->fetch();
$stmt->close();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nama_barang = trim($_POST['nama_barang']);
    $harga_beli  = (int) $_POST['harga_beli'];
    $harga_jual  = (int) $_POST['harga_jual'];
    $stok        = (int) $_POST['stok'];
    $tanpa_exp   = isset($_POST['tanpa_exp']) ? 1 : 0;
    $kadaluwarsa = !$tanpa_exp ? ($_POST['tgl'] ?? null) : null;

    if ($tanpa_exp) {
        $stmt = $conn->prepare("UPDATE barang SET 
                nama_barang=?, harga_beli=?, harga=?, stok=?, kadaluwarsa=NULL 
                WHERE barkode=?");
        $stmt->bind_param("siiis", $nama_barang, $harga_beli, $harga_jual, $stok, $barkode);
    } else {
        $stmt = $conn->prepare("UPDATE barang SET 
                nama_barang=?, harga_beli=?, harga=?, stok=?, kadaluwarsa=? 
                WHERE barkode=?");
        $stmt->bind_param("siiiss", $nama_barang, $harga_beli, $harga_jual, $stok, $kadaluwarsa, $barkode);
    }

    if ($stmt->execute()) {
        $pesan = "<p class='success'>✅ Data barang berhasil diperbarui!</p>";
    } else {
        $pesan = "<p class='error'>❌ Gagal memperbarui data barang!</p>";
    }
    $stmt->close();
}
$conn->close();
?>

<!DOCTYPE html>
<html>
<head>
<title>Edit Barang</title>
<style>
body {
    font-family: Verdana;
    background-color: #f8fafc;
}
h1 { color: #222; }
form {
    background: #ffffff;
    padding: 25px;
    border-radius: 12px;
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    width: 420px;
}
input[type=text], input[type=number], input[type=date] {
    width: 100%;
    padding: 8px;
    margin-top: 4px;
    margin-bottom: 10px;
    border: 1px solid #ccc;
    border-radius: 8px;
}
input[type=submit] {
    background-color: #28a745;
    color: white;
    border: none;
    padding: 10px 25px;
    border-radius: 8px;
    cursor: pointer;
}
input[type=submit]:hover {
    background-color: #1f7a33;
}
a {
    text-decoration: none;
    color: #007bff;
}
.success { color: green; font-weight: bold; }
.error { color: red; font-weight: bold; }
.checkbox-container {
    margin-top: 5px;
    margin-bottom: 15px;
}
</style>
<script>
function toggleTanggal() {
    const checkbox = document.getElementById('tanpa_exp');
    const tgl = document.getElementById('tgl');
    tgl.disabled = checkbox.checked;
    if (checkbox.checked) tgl.value = "";
}
</script>
</head>
<body>
<center>
    <h1>✏️ Edit Data Barang</h1>
    <div><?= $pesan ?></div>
    <form method="post">
        <label>Barcode:</label><br>
        <input type="text" name="barkode" value="<?= htmlspecialchars($barkode) ?>" readonly><br>

        <label>Nama Barang:</label><br>
        <input type="text" name="nama_barang" value="<?= htmlspecialchars($nama_barang) ?>" required><br>

        <label>Harga Beli:</label><br>
        <input type="number" name="harga_beli" value="<?= htmlspecialchars($harga_beli) ?>" required><br>

        <label>Harga Jual:</label><br>
        <input type="number" name="harga_jual" value="<?= htmlspecialchars($harga_jual) ?>" required><br>

        <label>Stok Barang:</label><br>
        <input type="number" name="stok" value="<?= htmlspecialchars($stok) ?>" required><br>

        <label>Tanggal Kadaluwarsa:</label><br>
        <input type="date" id="tgl" name="tgl" value="<?= htmlspecialchars($kadaluwarsa) ?>"><br>

        <div class="checkbox-container">
            <input type="checkbox" id="tanpa_exp" name="tanpa_exp" onclick="toggleTanggal()" 
                <?= $kadaluwarsa === null ? 'checked' : '' ?>>
            <label for="tanpa_exp">Barang tidak memiliki tanggal kadaluwarsa</label>
        </div>

        <input type="submit" value="Update Barang">
    </form>

    <br>
    <a href="tambah_barang.php">⬅️ Kembali ke Daftar Barang</a>
</center>
</body>
</html>
