<?php
session_start();
include 'db.php';

// 🔒 Cegah akses selain boss
if (!isset($_SESSION['username']) || $_SESSION['username'] !== 'boss') {
    header("Location: index.php");
    exit;
}

$pesan = "";

// 🗑️ Hapus operator
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['hapus'])) {
    $hapus_user = trim($_POST['hapus_user'] ?? '');

    if ($hapus_user === 'boss') {
        $pesan = "<span style='color:red;'>⚠️ Tidak bisa menghapus akun boss!</span>";
    } else {
        $stmt = $conn->prepare("DELETE FROM operator WHERE username = ?");
        $stmt->bind_param("s", $hapus_user);
        if ($stmt->execute()) {
            if ($stmt->affected_rows > 0) {
                $pesan = "<span style='color:green;'>✅ Operator <b>" . htmlspecialchars($hapus_user) . "</b> berhasil dihapus!</span>";
            } else {
                $pesan = "<span style='color:red;'>❌ Operator tidak ditemukan.</span>";
            }
        } else {
            $pesan = "<span style='color:red;'>❌ Gagal menghapus operator.</span>";
        }
        $stmt->close();
    }
}

// 🔍 Ambil daftar operator
$result = $conn->query("SELECT username FROM operator ORDER BY username ASC");

$conn->close();
?>

<html>
<head>
<title>Kelola Operator</title>
<style>
body {
    font-family: Verdana;
    background: #f7f7f7;
}
.container {
    width: 650px;
    margin: 60px auto;
    background: #ffffff;
    border-radius: 12px;
    padding: 30px 40px;
    box-shadow: 0 0 10px rgba(0,0,0,0.1);
}
input[type=text], input[type=password] {
    width: 95%;
    padding: 8px;
    margin: 6px 0 10px 0;
    border: 1px solid #ccc;
    border-radius: 5px;
}
input[type=submit] {
    background-color: #007bff;
    color: white;
    border: none;
    padding: 10px 20px;
    border-radius: 5px;
    cursor: pointer;
}
input[type=submit]:hover {
    background-color: #0056b3;
}
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 25px;
}
th, td {
    border: 1px solid #ccc;
    padding: 8px;
    text-align: center;
}
th {
    background-color: #007bff;
    color: white;
}
tr:nth-child(even) {
    background-color: #f2f2f2;
}
button {
    background-color: #dc3545;
    color: white;
    border: none;
    padding: 5px 10px;
    border-radius: 5px;
    cursor: pointer;
}
button:hover {
    background-color: #b52a36;
}
a {
    text-decoration: none;
    color: #007bff;
}
</style>
</head>

<body>
<div class="container">
<center>
    <?= $pesan ?><br><br>
</center>




<hr><br>
<center><b>Daftar Operator Terdaftar</b></center>
<table>
<tr>
    <th>No</th>
    <th>Username</th>
    <th>Aksi</th>
</tr>
<?php
$no = 1;
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $user = htmlspecialchars($row['username']);
        echo "<tr>
                <td>$no</td>
                <td>$user</td>
                <td>
                    <form method='post' onsubmit='return confirm(\"Yakin ingin menghapus operator $user ?\")'>
                        <input type='hidden' name='hapus_user' value='$user'>
                        <input type='submit' name='hapus' value='Hapus'>
                    </form>
                </td>
              </tr>";
        $no++;
    }
} else {
    echo "<tr><td colspan='3'><center>Belum ada operator terdaftar.</center></td></tr>";
}
?>
</table>

<br><center><a href="dashboard.php">[Kembali ke Dashboard]</a></center>
</div>
</body>
</html>
