<?php
session_start();
include 'db.php';

// Hanya boss yang bisa mendaftar operator
if (!isset($_SESSION['username']) || $_SESSION['username'] !== 'boss') {
    header("Location: index.php");
    exit;
}

$pesan = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['user'] ?? '');
    $sandi1   = trim($_POST['sandi1'] ?? '');
    $sandi2   = trim($_POST['sandi2'] ?? '');

    if ($username === '' || $sandi1 === '' || $sandi2 === '') {
        $pesan = "<p style='color:red;'>Semua kolom wajib diisi!</p>";
    } elseif ($sandi1 !== $sandi2) {
        $pesan = "<p style='color:red;'>Sandi tidak sama. Ulangi!</p>";
    } else {
        $hashed = password_hash($sandi1, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("INSERT INTO users (username, password) VALUES (?, ?)");
        $stmt->bind_param("ss", $username, $hashed);

        if ($stmt->execute()) {
            $pesan = "<p style='color:green;'>✅ Pendaftaran operator berhasil!</p>";
        } else {
            $pesan = "<p style='color:red;'>❌ Pendaftaran operator gagal: "
                   . htmlspecialchars($stmt->error) . "</p>";
        }
        $stmt->close();
    }
    $conn->close();
}
?>

<html>
<head>
<title>Pendaftaran Operator Baru</title>
<style>
body {
    font-family: Verdana, sans-serif;
    background: linear-gradient(135deg, #f5f7fa, #c3cfe2);
    color: #333;
}
.container {
    background: white;
    width: 400px;
    margin: 100px auto;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0px 0px 15px rgba(0,0,0,0.2);
    text-align: center;
}
input[type=text], input[type=password] {
    width: 80%;
    padding: 10px;
    border: 1px solid #ccc;
    border-radius: 8px;
}
input[type=submit] {
    background: #0066cc;
    color: white;
    border: none;
    padding: 10px 25px;
    border-radius: 8px;
    cursor: pointer;
}
input[type=submit]:hover {
    background: #004999;
}
a {
    text-decoration: none;
    color: #0066cc;
}
a:hover {
    text-decoration: underline;
}
</style>
</head>
<body>
<div class="container">
    <h2>Pendaftaran Operator Baru</h2>
    <?= $pesan ?>
    <form method="post">
        <p>Masukkan Username:</p>
        <input type="text" name="user" placeholder="contoh: operator1"><br><br>
        <p>Masukkan Password:</p>
        <input type="password" name="sandi1" placeholder="••••••"><br><br>
        <p>Ulangi Password:</p>
        <input type="password" name="sandi2" placeholder="••••••"><br><br>
        <input type="submit" value="Daftar">
    </form>
    <br>
    <a href="dashboard.php">← Kembali ke Dashboard</a>
</div>
</body>
</html>
