<?php
session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
   header("Location: index.php");
   exit;
}

$msg = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   $nama   = trim($_POST['nama']);
   $alamat = trim($_POST['alamat']);
   $email  = trim($_POST['email']);
   $telp   = trim($_POST['telp']);

   if ($nama && $alamat && $email && $telp) {
      $stmt = $conn->prepare("INSERT INTO pelanggan (Nama, Alamat, Email, No_hape) VALUES (?, ?, ?, ?)");
      $stmt->bind_param("ssss", $nama, $alamat, $email, $telp);

      if ($stmt->execute()) {
         $msg = "<div class='sukses'>✅ Data pelanggan berhasil disimpan.</div>";
      } else {
         $msg = "<div class='gagal'>❌ Data pelanggan gagal disimpan.</div>";
      }

      $stmt->close();
   } else {
      $msg = "<div class='gagal'>⚠️ Semua kolom wajib diisi!</div>";
   }

   $conn->close();
}
?>
<html>
<head>
   <title>Pendaftaran Pelanggan</title>
   <style>
      body {
         font-family: Verdana, sans-serif;
         background: linear-gradient(180deg, #f8f9fa, #dbe9ff);
         margin: 0;
         padding: 0;
      }
      .container {
         width: 420px;
         margin: 80px auto;
         background: #fff;
         padding: 30px;
         border-radius: 15px;
         box-shadow: 0 0 15px rgba(0,0,0,0.1);
         text-align: center;
      }
      h2 {
         color: #333;
         margin-bottom: 20px;
      }
      input[type=text], input[type=email] {
         width: 90%;
         padding: 10px;
         margin: 8px 0;
         border: 1px solid #ccc;
         border-radius: 8px;
         font-size: 14px;
      }
      input[type=submit], .btn-secondary {
         width: 95%;
         background: #007bff;
         color: white;
         border: none;
         padding: 10px;
         border-radius: 8px;
         font-size: 16px;
         cursor: pointer;
         margin-top: 5px;
      }
      input[type=submit]:hover {
         background: #0056b3;
      }
      .btn-secondary {
         background: #28a745;
         text-decoration: none;
         display: inline-block;
      }
      .btn-secondary:hover {
         background: #1e7e34;
      }
      .sukses {
         color: #155724;
         background: #d4edda;
         border: 1px solid #c3e6cb;
         padding: 10px;
         border-radius: 8px;
         margin-bottom: 10px;
      }
      .gagal {
         color: #721c24;
         background: #f8d7da;
         border: 1px solid #f5c6cb;
         padding: 10px;
         border-radius: 8px;
         margin-bottom: 10px;
      }
      a.link {
         display: inline-block;
         margin-top: 15px;
         color: #007bff;
         text-decoration: none;
      }
      a.link:hover {
         text-decoration: underline;
      }
   </style>
</head>
<body>
   <div class="container">
      <h2>Pendaftaran Pelanggan</h2>
      <?= $msg ?>
      <form method="post">
         <input type="text" name="nama" placeholder="Nama Pelanggan" required><br>
         <input type="text" name="alamat" placeholder="Alamat" required><br>
         <input type="email" name="email" placeholder="Email" required><br>
         <input type="text" name="telp" placeholder="No. Hape" required><br><br>
         <input type="submit" value="Simpan"><br>
      </form>
      <a href="dashboard.php" class="link">← Kembali ke Dashboard</a>
   </div>
</body>
</html>
