<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
   header("Location: index.php");
   exit;
}

$hasil = [];
$pesan = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // === CARI ===
    if (isset($_POST['cari'])) {
        $nama = trim($_POST['nama']);
        $kata = "%$nama%";

        $stmt = $conn->prepare("SELECT Nama, Alamat, Email, No_hape 
                                FROM pelanggan 
                                WHERE LOWER(Nama) LIKE LOWER(?)");
        $stmt->bind_param("s", $kata);
        $stmt->execute();
        $result = $stmt->get_result();

        while ($row = $result->fetch_assoc()) {
            $hasil[] = $row;
        }
        $stmt->close();

        if (empty($hasil)) {
            $pesan = "❌ Tidak ada pelanggan dengan nama mirip '$nama'.";
        }
    }

    // === HAPUS ===
    if (isset($_POST['hapus'])) {
        $nama_lama = trim($_POST['nama_lama']);

        $stmt = $conn->prepare("DELETE FROM pelanggan WHERE Nama=?");
        $stmt->bind_param("s", $nama_lama);
        if ($stmt->execute() && $stmt->affected_rows > 0) {
            $pesan = "✅ Data pelanggan '$nama_lama' berhasil dihapus.";
        } else {
            $pesan = "⚠️ Gagal menghapus '$nama_lama' atau data tidak ditemukan.";
        }
        $stmt->close();
    }

    $conn->close();
}
?>

<html>
<head>
<title>Hapus Data Pelanggan</title>
<style>
body {
   font-family: Verdana, sans-serif;
   background: #f5f5f5;
}
.container {
   background: white;
   border-radius: 12px;
   padding: 30px;
   box-shadow: 0 0 10px rgba(0,0,0,0.1);
   width: 800px;
   margin: 40px auto;
   text-align: center;
}
input[type=text], input[type=email] {
   width: 90%;
   padding: 8px;
   border: 1px solid #ccc;
   border-radius: 6px;
}
input[type=submit] {
   background-color: #cc0000;
   color: white;
   padding: 8px 18px;
   border: none;
   border-radius: 8px;
   cursor: pointer;
   font-size: 14px;
}
input[type=submit]:hover {
   background-color: #a00000;
}
.message {
   color: #333;
   margin: 15px 0;
   font-weight: bold;
}
table {
   width: 100%;
   border-collapse: collapse;
   margin-top: 20px;
}
th, td {
   border: 1px solid #ddd;
   padding: 8px;
}
th {
   background-color: #cc0000;
   color: white;
}
tr:nth-child(even) {background-color: #f2f2f2;}
a {
   text-decoration: none;
   color: #0066cc;
}
</style>

<script>
function konfirmasiHapus(nama) {
   return confirm("⚠️ Apakah Anda yakin ingin menghapus pelanggan bernama '" + nama + "'?");
}
</script>
</head>

<body>
<div class="container">
<h2>🔍 Cari & Hapus Data Pelanggan</h2>

<form method="post">
   <label>Nama Pelanggan yang akan dihapus:</label><br>
   <input type="text" name="nama" required><br><br>
   <input type="submit" name="cari" value="Cari">
</form>

<?php if ($pesan): ?>
   <div class="message"><?= htmlspecialchars($pesan) ?></div>
<?php endif; ?>

<?php if (!empty($hasil)): ?>
<h3>Hasil Pencarian:</h3>
<table>
<tr>
   <th>Nama</th>
   <th>Alamat</th>
   <th>Email</th>
   <th>No. Hape</th>
   <th>Aksi</th>
</tr>
<?php foreach ($hasil as $row): ?>
<tr>
   <td><?= htmlspecialchars($row['Nama']) ?></td>
   <td><?= htmlspecialchars($row['Alamat']) ?></td>
   <td><?= htmlspecialchars($row['Email']) ?></td>
   <td><?= htmlspecialchars($row['No_hape']) ?></td>
   <td>
      <form method="post" style="display:inline;" onsubmit="return konfirmasiHapus('<?= htmlspecialchars($row['Nama']) ?>')">
         <input type="hidden" name="nama_lama" value="<?= htmlspecialchars($row['Nama']) ?>">
         <input type="submit" name="hapus" value="Hapus">
      </form>
   </td>
</tr>
<?php endforeach; ?>
</table>
<?php endif; ?>

<br><br>
<a href="dashboard.php">← Kembali ke Dashboard</a>
</div>
</body>
</html>
