<?php
// =======================================
// update_dokter.php
// =======================================
session_start();
include 'db.php'; // pastikan file ini berisi variabel: $servername, $username, $password, $database

// 🔒 Wajib login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// --- Variabel dasar ---
$pesan = "";
$data_dr = [
    'no_id' => '',
    'Nama_dokter' => '',
    'Spesialis' => '',
    'Alamat_dokter' => '',
    'No_hape' => '',
    'Keterangan' => ''
];

// --- Koneksi ---
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . htmlspecialchars($conn->connect_error));
}

// --- Fungsi aman HTML ---
function e($s) {
    return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8');
}

// =====================================================
// 1) PROSES UPDATE DATA
// =====================================================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update'])) {
    $no_id   = intval($_POST['no_id'] ?? 0);
    $nama    = trim($_POST['nama'] ?? '');
    $spes    = trim($_POST['spesialis'] ?? '');
    $alamat  = trim($_POST['alamat'] ?? '');
    $telp    = trim($_POST['telp'] ?? '');
    $ket     = trim($_POST['keterangan'] ?? '');

    if ($no_id <= 0 || $nama === '' || $spes === '' || $alamat === '' || $telp === '') {
        $pesan = "<span style='color:#c00;'>⚠️ Harap lengkapi semua data penting.</span>";
    } else {
        $stmt = $conn->prepare("UPDATE dokter 
                                SET Nama_dokter=?, Spesialis=?, Alamat_dokter=?, No_hape=?, Keterangan=? 
                                WHERE no_id=?");
        if (!$stmt) {
            $pesan = "<span style='color:#c00;'>Query error: " . e($conn->error) . "</span>";
        } else {
            $stmt->bind_param("sssssi", $nama, $spes, $alamat, $telp, $ket, $no_id);
            if ($stmt->execute()) {
                $pesan = "<span style='color:green;'>✅ Data dokter berhasil diupdate.</span>";
            } else {
                $pesan = "<span style='color:#c00;'>❌ Gagal update data dokter.</span>";
            }
            $stmt->close();
        }

        // ambil ulang untuk ditampilkan
        $stmt = $conn->prepare("SELECT no_id, Nama_dokter, Spesialis, Alamat_dokter, No_hape, Keterangan FROM dokter WHERE no_id=?");
        $stmt->bind_param("i", $no_id);
        $stmt->execute();
        $stmt->bind_result($data_dr['no_id'], $data_dr['Nama_dokter'], $data_dr['Spesialis'], $data_dr['Alamat_dokter'], $data_dr['No_hape'], $data_dr['Keterangan']);
        $stmt->fetch();
        $stmt->close();
    }
}

// =====================================================
// 2) PILIH SATU DOKTER DARI DAFTAR
// =====================================================
$hasil_list = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['pilih_id'])) {
    $pilih_id = intval($_POST['pilih_id']);
    if ($pilih_id > 0) {
        $stmt = $conn->prepare("SELECT no_id, Nama_dokter, Spesialis, Alamat_dokter, No_hape, Keterangan FROM dokter WHERE no_id=?");
        $stmt->bind_param("i", $pilih_id);
        $stmt->execute();
        $stmt->bind_result($data_dr['no_id'], $data_dr['Nama_dokter'], $data_dr['Spesialis'], $data_dr['Alamat_dokter'], $data_dr['No_hape'], $data_dr['Keterangan']);
        if (!$stmt->fetch()) {
            $pesan = "<span style='color:#c00;'>Data dokter tidak ditemukan.</span>";
        }
        $stmt->close();
    }
}

// =====================================================
// 3) PENCARIAN DOKTER (tidak case-sensitive & hanya 1 kata)
// =====================================================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['cari'])) {
    $raw = trim($_POST['keyword'] ?? '');
    // ambil kata pertama saja
    $keyword = preg_split('/\s+/u', $raw, 2)[0] ?? '';

    if ($keyword === '') {
        $pesan = "<span style='color:#c00;'>Masukkan minimal satu kata untuk pencarian.</span>";
    } else {
        $like = "%" . $keyword . "%";
        $stmt = $conn->prepare("
            SELECT no_id, Nama_dokter, Spesialis, Alamat_dokter, No_hape, Keterangan
            FROM dokter
            WHERE LOWER(Nama_dokter) LIKE LOWER(?)
            ORDER BY Nama_dokter ASC
        ");
        if (!$stmt) {
            $pesan = "<span style='color:#c00;'>Query error: " . e($conn->error) . "</span>";
        } else {
            $stmt->bind_param("s", $like);
            $stmt->execute();
            $result = $stmt->get_result();
            $rows = $result->fetch_all(MYSQLI_ASSOC);
            $stmt->close();

            if (count($rows) === 0) {
                $pesan = "<span style='color:#c00;'>❌ Tidak ada data dokter yang cocok dengan kata: <b>" . e($keyword) . "</b></span>";
            } elseif (count($rows) === 1) {
                $data_dr = $rows[0];
                $pesan = "<span style='color:green;'>✅ Ditemukan 1 data cocok.</span>";
            } else {
                $hasil_list = $rows;
                $pesan = "<span style='color:#06c;'>🔍 Ditemukan " . count($rows) . " data. Silakan pilih salah satu.</span>";
            }
        }
    }
}

?>
<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Update Data Dokter</title>
<style>
body {
    font-family: Verdana, Arial, sans-serif;
    background: #f6f7fb;
    padding: 20px;
}
.container {
    max-width: 960px;
    margin: auto;
    background: #fff;
    padding: 20px;
    border-radius: 12px;
    box-shadow: 0 2px 6px rgba(0,0,0,.1);
}
h2 { margin-top: 0; color:#333; }
input[type=text], textarea {
    width: 100%;
    padding: 8px;
    border: 1px solid #ccc;
    border-radius: 6px;
}
textarea { resize: vertical; height: 70px; }
button {
    padding: 8px 14px;
    border: 0;
    border-radius: 6px;
    cursor: pointer;
    font-weight: bold;
}
.btn-primary { background: #2563eb; color: #fff; }
.btn-secondary { background: #6b7280; color: #fff; }
.btn-warning { background: #d97706; color: #fff; }
table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 10px;
}
th, td {
    border-bottom: 1px solid #ddd;
    padding: 8px;
    font-size: 14px;
}
th { background: #f3f4f6; }
.msg { margin: 10px 0; }
</style>
</head>
<body>
<div class="container">
<h2>Update Data Dokter</h2><br><br>
<a href="dashboard.php"><font face=verdana size=3>[Kembali]</font></a><br><br>

<!-- FORM PENCARIAN -->
<form method="post">
    <label><b>Masukkan Nama Dokter (1 kata, tidak case-sensitive):</b></label><br>
    <input type="text" name="keyword" placeholder="contoh: budi" required>
    <button type="submit" name="cari" class="btn-primary">Cari</button>
</form>

<div class="msg"><?= $pesan ?></div>

<!-- TABEL HASIL PENCARIAN -->
<?php if (!empty($hasil_list)): ?>
<table>
    <tr>
        <th>Nama Dokter</th>
        <th>Spesialis</th>
        <th>No. Hape</th>
        <th>Alamat</th>
        <th>Pilih</th>
    </tr>
    <?php foreach ($hasil_list as $r): ?>
    <tr>
        <td><?= e($r['Nama_dokter']) ?></td>
        <td><?= e($r['Spesialis']) ?></td>
        <td><?= e($r['No_hape']) ?></td>
        <td><?= e($r['Alamat_dokter']) ?></td>
        <td>
            <form method="post">
                <input type="hidden" name="pilih_id" value="<?= e($r['no_id']) ?>">
                <button class="btn-secondary" type="submit">Pilih</button>
            </form>
        </td>
    </tr>
    <?php endforeach; ?>
</table>
<?php endif; ?>

<!-- FORM EDIT DOKTER -->
<hr>
<h3>Edit Data Dokter</h3>
<form method="post">
    <input type="hidden" name="no_id" value="<?= e($data_dr['no_id']) ?>">

    <label>Nama Dokter:</label><br>
    <input type="text" name="nama" value="<?= e($data_dr['Nama_dokter']) ?>" required><br><br>

    <label>Spesialis:</label><br>
    <input type="text" name="spesialis" value="<?= e($data_dr['Spesialis']) ?>" required><br><br>

    <label>No. Hape:</label><br>
    <input type="text" name="telp" value="<?= e($data_dr['No_hape']) ?>" required><br><br>

    <label>Alamat:</label><br>
    <textarea name="alamat" required><?= e($data_dr['Alamat_dokter']) ?></textarea><br><br>

    <label>Keterangan:</label><br>
    <textarea name="keterangan"><?= e($data_dr['Keterangan']) ?></textarea><br><br>

    <button type="submit" name="update" class="btn-warning" <?= $data_dr['no_id'] ? '' : 'disabled' ?>>Update</button>
</form>

</div>
</body>
</html>
