<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
include 'db.php';

if (!isset($_SESSION['username'])) {
   header("Location: login.php");
   exit;
}

$conn = new mysqli($servername, $username, $password, $database);
$conn->set_charset("utf8mb4");
if ($conn->connect_error) {
   die("Koneksi gagal: " . $conn->connect_error);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   $cariobat   = trim($_POST['cariobat']);
   $caripasien = trim($_POST['caripasien']);
   $caridokter = trim($_POST['caridokter']);
   $jumlah_beli = (int)$_POST['jumlah_beli'];
   $keterangan = trim($_POST['keterangan'] ?? '');

   // --- Ambil data obat ---
   $stmt = $conn->prepare("SELECT no_id, Kodebar, Nama_obat, Kategori,
      Harga_asli_obat, Harga_jual_obat, Stok, Dosis, Keterangan, Gbr_obat 
      FROM obat WHERE LOWER(Nama_obat) LIKE CONCAT('%', LOWER(?), '%')");
   $stmt->bind_param("s", $cariobat);
   $stmt->execute();
   $stmt->bind_result($noid, $kodebar, $nama_obat, $kategori, $harga_beli, $harga_jual, $stok, $dosis, $ket, $gbr_obat);
   $stmt->fetch();
   $stmt->close();

   if (empty($noid)) {
      echo "<div class='notif error'>❌ Nama obat tidak ditemukan!</div>";
      exit;
   }

   // --- Ambil data pasien ---
   $stmt = $conn->prepare("SELECT no_id, Nama_pasien, Kelamin, Umur, Alamat, No_hape, Keterangan 
      FROM pasien WHERE LOWER(Nama_pasien) LIKE CONCAT('%', LOWER(?), '%')");
   $stmt->bind_param("s", $caripasien);
   $stmt->execute();
   $stmt->bind_result($nomor_id, $nama_pasien, $kelamin, $umur, $alamat, $no_hape, $keter);
   $stmt->fetch();
   $stmt->close();

   if (empty($nomor_id)) {
      echo "<div class='notif error'>❌ Nama pasien tidak ditemukan!</div>";
      exit;
   }

   // --- Ambil data dokter ---
   $stmt = $conn->prepare("SELECT no_id, Nama_dokter, Spesialis, Alamat_dokter,
      No_hape, Keterangan FROM dokter WHERE LOWER(Nama_dokter) LIKE CONCAT('%', LOWER(?), '%')");
   $stmt->bind_param("s", $caridokter);
   $stmt->execute();
   $stmt->bind_result($nomr_id, $nama_dokter, $spesialis, $alamat_dokter, $nomr_hape, $ketr);
   $stmt->fetch();
   $stmt->close();

   if (empty($nomr_id)) {
      echo "<div class='notif error'>❌ Nama dokter tidak ditemukan!</div>";
      exit;
   }

   // --- Validasi stok ---
   if ($stok < $jumlah_beli) {
      echo "<div class='notif error'>❌ Stok obat tidak mencukupi!</div>";
      exit;
   }

   // --- Data transaksi ---
   $tgl_beli = date('Y-m-d H:i:s');
   $tot_harga = $harga_jual * $jumlah_beli;
   $lunas_int = 0; // false

   // --- Simpan transaksi ---
   $stmt = $conn->prepare("INSERT INTO transaksi 
      (No_pasien, No_obat, No_dokter, Tanggal_beli, Jumlah_beli, Total_harga, Keterangan, Lunas) 
      VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
   $stmt->bind_param("iiisissi", $nomor_id, $noid, $nomr_id, $tgl_beli, $jumlah_beli, $tot_harga, $keterangan, $lunas_int);
   $stmt->execute();
   $stmt->close();

   // --- Update stok obat ---
   $stok_baru = $stok - $jumlah_beli;
   $stmt = $conn->prepare("UPDATE obat SET Stok = ? WHERE no_id = ?");
   $stmt->bind_param("ii", $stok_baru, $noid);
   $stmt->execute();
   $stmt->close();

   echo "
   <div class='card hasil'>
      <h2>✅ Transaksi Berhasil</h2>
      <p><b>Tanggal Beli:</b> $tgl_beli</p>
      <p><b>Nama Pasien:</b> $nama_pasien</p>
      <p><b>Nama Obat:</b> $nama_obat</p>
      <p><b>Nama Dokter:</b> $nama_dokter</p>
      <p><b>Jumlah Beli:</b> $jumlah_beli</p>
      <p><b>Total Harga:</b> Rp. " . number_format($tot_harga, 0, ',', '.') . "</p>
      <a href='dashboard.php' class='btn-back'>Kembali ke Dashboard</a>
   </div>
   ";
   $conn->close();
   exit;
}
?>

<html>
<head>
<title>Penjualan Obat - Apotek Mekar Jaya</title>
<style>
   body {
      font-family: "Verdana", sans-serif;
      background: linear-gradient(135deg, #e3f2fd, #bbdefb);
      color: #333;
      margin: 0;
      padding: 0;
   }
   .container {
      width: 90%;
      max-width: 600px;
      margin: 50px auto;
      background: #fff;
      border-radius: 15px;
      box-shadow: 0 5px 20px rgba(0,0,0,0.1);
      padding: 30px;
      text-align: center;
   }
   h1 {
      color: #1565c0;
      font-size: 26px;
      margin-bottom: 20px;
   }
   input[type="text"],
   input[type="number"],
   textarea {
      width: 90%;
      padding: 10px;
      font-size: 14px;
      margin: 8px 0;
      border: 1px solid #ccc;
      border-radius: 8px;
      transition: 0.2s;
   }
   input[type="text"]:focus,
   input[type="number"]:focus,
   textarea:focus {
      border-color: #1976d2;
      box-shadow: 0 0 5px rgba(25,118,210,0.5);
      outline: none;
   }
   .btn {
      background: #1976d2;
      color: white;
      border: none;
      padding: 12px 25px;
      border-radius: 8px;
      font-size: 16px;
      cursor: pointer;
      margin-top: 15px;
      transition: 0.3s;
   }
   .btn:hover {
      background: #0d47a1;
   }
   .btn-back {
      display: inline-block;
      margin-top: 20px;
      text-decoration: none;
      color: white;
      background: #43a047;
      padding: 10px 20px;
      border-radius: 8px;
      transition: 0.3s;
   }
   .btn-back:hover {
      background: #2e7d32;
   }
   .notif {
      width: 80%;
      margin: 50px auto;
      padding: 20px;
      border-radius: 10px;
      text-align: center;
      font-size: 18px;
   }
   .notif.error {
      background: #ffebee;
      color: #c62828;
      border: 2px solid #ef9a9a;
   }
   .card.hasil {
      max-width: 500px;
      margin: 50px auto;
      background: #e8f5e9;
      padding: 25px;
      border-radius: 15px;
      box-shadow: 0 3px 15px rgba(0,0,0,0.1);
      text-align: left;
   }
</style>
</head>
<body>
<div class="container">
   <h1>🧾 Penjualan Obat Dengan Resep Dokter</h1>
   <form method="post">
      <label>Nama Obat:</label><br>
      <input type="text" name="cariobat" required><br>
      
      <label>Nama Pasien:</label><br>
      <input type="text" name="caripasien" required><br>
      
      <label>Nama Dokter:</label><br>
      <input type="text" name="caridokter" required><br>
      
      <label>Keterangan:</label><br>
      <textarea name="keterangan" rows="4"></textarea><br>
      
      <label>Jumlah Beli:</label><br>
      <input type="number" name="jumlah_beli" min="1" required><br>
      
      <button type="submit" class="btn">💾 Simpan Transaksi</button><br>
      <a href="dashboard.php" class="btn-back">← Kembali</a>
   </form>
</div>
</body>
</html>
