<?php
// file: setup.php
session_start();
include 'db.php';

// Pastikan user login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// --- Ambil data logo lama ---
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

$nama_lama = $nama_apoteker_lama = $no_apoteker_lama = $alamat_lama = $logo_lama = "";

$stmt = $conn->prepare("SELECT Nama_apotek, Nama_apoteker, No_apoteker, Alamat, Logo_apotek FROM logo LIMIT 1");
$stmt->execute();
$stmt->bind_result($nama_lama, $nama_apoteker_lama, $no_apoteker_lama, $alamat_lama, $logo_lama);
$stmt->fetch();
$stmt->close();

// --- Proses form jika dikirim ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nama   = trim($_POST['nama'] ?? '');
    $nama_apoteker = trim($_POST['nama_apoteker'] ?? '');
    $no_apoteker = trim($_POST['no_apoteker'] ?? '');
    $alamat = trim($_POST['alamat'] ?? '');
    $target_dir = ""; // simpan ke folder gambar/

    // Nama file logo
    $nama_file = basename($_FILES["logo"]["name"]);
    $target_file = $target_dir . $nama_file;
    $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
    $uploadOk = 1;

    // --- Validasi file gambar ---
    if (!empty($_FILES["logo"]["tmp_name"])) {
        $check = getimagesize($_FILES["logo"]["tmp_name"]);
        if ($check === false) {
            echo "❌ File bukan gambar.<br>";
            $uploadOk = 0;
        }

        if ($_FILES["logo"]["size"] > 5000000) {
            echo "❌ Ukuran file terlalu besar (maks 5MB).<br>";
            $uploadOk = 0;
        }

        if (!in_array($imageFileType, ["jpg", "jpeg", "png", "gif"])) {
            echo "❌ Hanya file JPG, JPEG, PNG & GIF yang diizinkan.<br>";
            $uploadOk = 0;
        }

        if ($uploadOk == 1) {
            if (move_uploaded_file($_FILES["logo"]["tmp_name"], $target_file)) {
                echo "<p style='color:green;'>✅ File berhasil diupload.</p>";
                $logo_baru = $target_file;
            } else {
                echo "<p style='color:red;'>⚠️ Gagal upload file.</p>";
                $logo_baru = $logo_lama;
            }
        } else {
            $logo_baru = $logo_lama;
        }
    } else {
        // Jika tidak upload logo baru → tetap pakai lama
        $logo_baru = $logo_lama;
    }

    // --- Simpan perubahan ke database ---
    $stmt = $conn->prepare("UPDATE logo SET Nama_apotek=?, Nama_apoteker=?, No_apoteker=?, Alamat=?, Logo_apotek=? LIMIT 1");
    $stmt->bind_param("sssss", $nama, $nama_apoteker, $no_apoteker, $alamat, $logo_baru);

    if ($stmt->execute()) {
        echo "<p style='color:green;'>✅ Data berhasil diperbarui!</p>";
        $nama_lama = $nama;
        $nama_apoteker_lama = $nama_apoteker;
        $no_apoteker_lama = $no_apoteker;
        $alamat_lama = $alamat;
        $logo_lama = $logo_baru;
    } else {
        echo "<p style='color:red;'>❌ Gagal memperbarui data: " . htmlspecialchars($stmt->error) . "</p>";
    }

    $stmt->close();
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Setup Apotek</title>
<style>
    body { font-family: Verdana; text-align: center; background-color: #f9f9f9; }
    .preview {
        display: flex;
        justify-content: center;
        align-items: flex-start;
        gap: 40px;
        margin-top: 20px;
        flex-wrap: wrap;
    }
    .card {
        background: white;
        border-radius: 10px;
        padding: 20px;
        box-shadow: 0 0 10px rgba(0,0,0,0.1);
        width: 300px;
    }
    img {
        border: 1px solid #ccc;
        border-radius: 10px;
        width: 250px;
        height: 250px;
        object-fit: cover;
    }
    input[type=text], input[type=file] {
        padding: 8px;
        border-radius: 5px;
        border: 1px solid #ccc;
    }
    input[type=submit] {
        background-color: #4CAF50;
        color: white;
        border: none;
        padding: 10px 25px;
        border-radius: 5px;
        cursor: pointer;
    }
    input[type=submit]:hover {
        background-color: #45a049;
    }
</style>
</head>
<body>

<h1>Edit Profil Apotek</h1>

<form method="post" enctype="multipart/form-data">
    <label><b>Nama Apotek:</b></label><br>
    <input type="text" name="nama" value="<?= htmlspecialchars($nama_lama) ?>" size="50" required><br><br>

    <label><b>Nama Apoteker:</b></label><br>
    <input type="text" name="nama_apoteker" value="<?= htmlspecialchars($nama_apoteker_lama) ?>" size="50" required><br><br>
    
    <label><b>Nomor Apoteker:</b></label><br>
    <input type="text" name="no_apoteker" value="<?= htmlspecialchars($no_apoteker_lama) ?>" size="50" required><br><br>

    <label><b>Alamat Apotek:</b></label><br>
    <input type="text" name="alamat" value="<?= htmlspecialchars($alamat_lama) ?>" size="50" required><br><br>

    <label><b>Logo Apotek (350px x 350px):</b></label><br>
    <input type="file" name="logo" accept="image/*"><br><br>

    <input type="submit" value="💾 Simpan Perubahan">
</form>

<div class="preview">
    <div class="card">
        <h3>Logo Saat Ini</h3>
        <?php if ($logo_lama && file_exists($logo_lama)): ?>
            <img src="<?= htmlspecialchars($logo_lama) ?>" alt="Logo Apotek">
        <?php else: ?>
            <p><i>Belum ada logo.</i></p>
        <?php endif; ?>
    </div>
</div>

</body>
</html>
