<?php
// registrasi karyawan apotek (operator apotek)
// password di-hash pakai password_hash
// username (bukan email)

session_start();
include 'db.php'; // pastikan di sini terdapat $servername, $username, $password, $database


if ($_SESSION['username'] !== 'admin' ) {
    header("Location: login.php");
    exit;
}


// Ambil data dari form
$opt = trim($_POST['opt'] ?? '');
$sandi = trim($_POST['sandi'] ?? '');
$sandi2 = trim($_POST['sandi2'] ?? '');

// Validasi
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    if ($opt === '' || $sandi === '' || $sandi2 === '') {
        echo "<p style='color:red'>Semua kolom wajib diisi!</p>";
        exit;
    }

    if ($sandi !== $sandi2) {
        echo "<p style='color:red'>Sandi harus sama. Ulangi!</p>";
        exit;
    }

    // Koneksi ke database (gunakan variabel dari db.php)
    $conn = new mysqli($servername, $username, $password, $database);
    if ($conn->connect_error) {
        die("Koneksi gagal: " . $conn->connect_error);
    }

    // Hash password
    $hashed = password_hash($sandi, PASSWORD_DEFAULT);

    // Cek apakah username sudah ada
    $cek = $conn->prepare("SELECT username FROM operator WHERE username = ?");
    $cek->bind_param("s", $opt);
    $cek->execute();
    $cek->store_result();

    if ($cek->num_rows > 0) {
        echo "<p style='color:red'>Username sudah terdaftar!</p>";
        $cek->close();
        $conn->close();
        exit;
    }
    $cek->close();

    // Simpan data baru
    $stmt = $conn->prepare("INSERT INTO operator (username, password) VALUES (?, ?)");
    $stmt->bind_param("ss", $opt, $hashed);

    if ($stmt->execute()) {
        echo "<p style='color:green'>✅ Operator berhasil didaftarkan!</p>";
    } else {
        echo "<p style='color:red'>❌ Gagal menyimpan data!</p>";
    }

    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Registrasi Operator Apotek</title>
<style>
body {
    font-family: Verdana, sans-serif;
    background: #f9f9f9;
}
form {
    margin-top: 50px;
    background: #fff;
    padding: 30px;
    border-radius: 10px;
    width: 400px;
    box-shadow: 0 0 10px rgba(0,0,0,0.1);
}
input {
    margin: 8px 0;
    padding: 8px;
    width: 100%;
    font-size: 16px;
}
input[type=submit] {
    background: #007bff;
    color: #fff;
    border: none;
    cursor: pointer;
}
input[type=submit]:hover {
    background: #0056b3;
}
</style>
</head>
<body>
<center>
<form method="post">
    <h2>🧑‍⚕️ Registrasi Operator Apotek</h2>
    <label>Masukkan Username<br>(max. 13 karakter)</label><br>
    <input type="text" name="opt" maxlength="13" required><br>

    <label>Masukkan Password</label><br>
    <input type="password" name="sandi" required><br>

    <label>Ulangi Password</label><br>
    <input type="password" name="sandi2" required><br><br>

    <input type="submit" value="Daftar"><br><br>
    <a href="dashboard.php">[Selesai]</a>
</form>
</center>
</body>
</html>
