<?php
session_start();
include 'db.php'; // pastikan ada $servername, $username, $password, $database

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $user = trim($_POST['user'] ?? '');
    $pass = trim($_POST['pass'] ?? '');

    if ($user === '' || $pass === '') {
        $pesan = "⚠️ Harap isi semua kolom.";
    } else {
        $conn = new mysqli($servername, $username, $password, $database);
        if ($conn->connect_error) {
            die("<p style='color:red;'>Koneksi gagal: " . htmlspecialchars($conn->connect_error) . "</p>");
        }

        $stmt = $conn->prepare("SELECT password FROM operator WHERE username = ?");
        if (!$stmt) {
            die("<p style='color:red;'>Query error: " . htmlspecialchars($conn->error) . "</p>");
        }

        $stmt->bind_param("s", $user);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows > 0) {
            $stmt->bind_result($hash);
            $stmt->fetch();

            if (password_verify($pass, $hash)) {
                $_SESSION['username'] = $user;
                header("Location: dashboard.php");
                exit;
            } else {
                $pesan = "❌ Password salah!";
            }
        } else {
            $pesan = "⚠️ Username tidak ditemukan!";
        }

        $stmt->close();
        $conn->close();
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Login Operator</title>
<style>
body {
  font-family: Verdana, sans-serif;
  background: linear-gradient(135deg, #89CFF0, #4682B4);
  height: 100vh;
  margin: 0;
  display: flex;
  align-items: center;
  justify-content: center;
}

.login-box {
  background: white;
  padding: 40px 50px;
  border-radius: 15px;
  box-shadow: 0px 8px 20px rgba(0,0,0,0.2);
  width: 350px;
  text-align: center;
}

.login-box h2 {
  color: #003366;
  margin-bottom: 25px;
}

input[type="text"], input[type="password"] {
  width: 90%;
  padding: 10px;
  margin: 8px 0;
  border: 1px solid #ccc;
  border-radius: 8px;
  font-size: 14px;
}

button {
  width: 95%;
  background: #4682B4;
  color: white;
  padding: 10px;
  border: none;
  border-radius: 8px;
  font-size: 15px;
  cursor: pointer;
  transition: 0.3s;
}

button:hover {
  background: #2E5984;
}

.message {
  color: red;
  font-weight: bold;
  margin-bottom: 10px;
}
</style>
</head>

<body>
<div class="login-box">
  <h2>Login Operator</h2>

  <?php if (!empty($pesan)) echo "<div class='message'>$pesan</div>"; ?>

  <form method="POST">
    <input type="text" name="user" placeholder="Masukkan Username" required><br>
    <input type="password" name="pass" placeholder="Masukkan Password" required><br><br>
    <button type="submit">Masuk</button>
  </form>
</div>
</body>
</html>
