<?php
session_start();
include 'db.php';

// Cek login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// Koneksi
$mysqli = new mysqli($servername, $username, $password, $database);
if ($mysqli->connect_error) {
    die("Koneksi gagal: " . $mysqli->connect_error);
}

// Jika tombol HAPUS diklik
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['hapus'])) {
    $hapus_id = trim($_POST['hapus']);
    $stmt = $mysqli->prepare("DELETE FROM transaksi WHERE no_trans = ?");
    $stmt->bind_param("s", $hapus_id);

    if ($stmt->execute()) {
        echo "<p style='color:green; text-align:center; font-family:verdana;'>✅ Transaksi dengan No. $hapus_id berhasil dihapus.</p>";
    } else {
        echo "<p style='color:red; text-align:center; font-family:verdana;'>❌ Gagal menghapus transaksi.</p>";
    }

    $stmt->close();
}

// Ambil semua data transaksi
$sql = "
SELECT 
  transaksi.no_trans,
  transaksi.Tanggal_beli,
  pasien.Nama_pasien,
  obat.Nama_obat,
  dokter.Nama_dokter,
  transaksi.Jumlah_beli,
  transaksi.Total_harga,
  transaksi.Keterangan,
  transaksi.Lunas
FROM transaksi
LEFT JOIN pasien ON transaksi.No_pasien = pasien.no_id
LEFT JOIN obat ON transaksi.No_obat = obat.no_id
LEFT JOIN dokter ON transaksi.No_dokter = dokter.no_id
ORDER BY transaksi.Tanggal_beli DESC
";

$result = $mysqli->query($sql);

// Judul tabel
echo "<center><font face='verdana' size='5'><b>DAFTAR TRANSAKSI</b></font></center><br>";

echo "<table border='0' cellpadding='8' cellspacing='1' bgcolor='#000000' align='center'>
<tr bgcolor='#cccccc'>
  <td><b>No.Transaksi</b></td>
  <td><b>Tanggal</b></td>
  <td><b>Nama Pasien</b></td>
  <td><b>Nama Obat</b></td>
  <td><b>Nama Dokter</b></td>
  <td><b>Jumlah Beli</b></td>
  <td><b>Total Harga</b></td>
  <td><b>Keterangan</b></td>
  <td><b>Lunas</b></td>
  <td><b>Aksi</b></td>
</tr>";

if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        echo "<tr bgcolor='#ffffff'>";
        echo "<td>" . htmlspecialchars($row['no_trans']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Tanggal_beli']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Nama_pasien'] ?? '-') . "</td>";
        echo "<td>" . htmlspecialchars($row['Nama_obat'] ?? '-') . "</td>";
        echo "<td>" . htmlspecialchars($row['Nama_dokter'] ?? '-') . "</td>";
        echo "<td align='right'>" . htmlspecialchars($row['Jumlah_beli']) . "</td>";
        echo "<td align='right'>Rp " . number_format($row['Total_harga'], 0, ',', '.') . "</td>";
        echo "<td>" . htmlspecialchars($row['Keterangan'] ?? '-') . "</td>";
        echo "<td align='center'>" . ($row['Lunas'] ? '✅' : '❌') . "</td>";
        echo "<td align='center'>
                <form method='POST' onsubmit='return confirm(\"Yakin ingin menghapus transaksi ini?\");'>
                    <input type='hidden' name='hapus' value='" . htmlspecialchars($row['no_trans']) . "'>
                    <input type='submit' value='HAPUS' style='background-color:red; color:white; border:none; padding:5px 10px; border-radius:4px; cursor:pointer;'>
                </form>
              </td>";
        echo "</tr>";
    }
} else {
    echo "<tr bgcolor='#ffffff'><td colspan='10' align='center'>Tidak ada data transaksi.</td></tr>";
}

echo "</table>";

echo "<br><br><br><center><a href='dashboard.php'>[Kembali]</a></center>";

$mysqli->close();
?>
