<?php
session_start();
include 'db.php';

// ✅ Hanya admin yang boleh akses
if (!isset($_SESSION['username']) || $_SESSION['username'] !== 'admin') {
    header("Location: login.php");
    exit;
}

// ✅ Buat koneksi
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("<p style='color:red;'>Koneksi gagal: " . htmlspecialchars($conn->connect_error) . "</p>");
}

// ------------------------------------
// 🔥 Proses penghapusan jika tombol YA diklik
// ------------------------------------
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['hapus'])) {
    $user = trim($_POST['hapus']);
    $stmt = $conn->prepare("DELETE FROM operator WHERE username = ?");
    $stmt->bind_param("s", $user);
    if ($stmt->execute()) {
        echo "<center><font face='verdana' color='green'>✅ Akun <b>" . htmlspecialchars($user) . "</b> berhasil dihapus.</font></center><br>";
    } else {
        echo "<center><font face='verdana' color='red'>❌ Gagal menghapus akun.</font></center><br>";
    }
    $stmt->close();
}

// ------------------------------------
// 📋 Tampilkan daftar operator
// ------------------------------------
$sql = "SELECT username FROM operator ORDER BY username ASC";
$result = $conn->query($sql);

echo "<center><font face='verdana' size='5'><b>DAFTAR USERNAME OPERATOR</b></font></center><br>";

echo "<table border='0' cellpadding='8' cellspacing='1' bgcolor='#000000' align='center'>
<tr bgcolor='#cccccc'>
  <td><b>Username Operator</b></td>
  <td><b>Aksi</b></td>
</tr>";

// ------------------------------------
// 🧾 Tampilkan data ke tabel
// ------------------------------------
if ($result && $result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $username = htmlspecialchars($row['username']);
        echo "<tr bgcolor='#ffffff'>";
        echo "<td>$username</td>";
        echo "<td align='center'>
                <form method='post' style='margin:0; display:inline;' onsubmit='return konfirmasiHapus(\"$username\")'>
                    <button type='submit' name='hapus' value='$username' style='background-color:#ff4444; color:white; border:none; padding:5px 10px; font-family:verdana; cursor:pointer;'>
                        HAPUS
                    </button>
                </form>
              </td>";
        echo "</tr>";
    }
    echo "</table>";
} else {
    echo "<center><font face='verdana' size='4' color='red'>Tidak ada data ditemukan.</font></center>";
}

// Tutup koneksi
$conn->close();
?>

<script>
// 🧠 Konfirmasi sebelum hapus
function konfirmasiHapus(user) {
    return confirm('Yakin ingin menghapus akun: ' + user + ' ?');
}
</script>

<center style='margin-top:20px;'>
    <a href='dashboard.php' style='font-family:verdana; text-decoration:none; background-color:#0080ff; color:white; padding:6px 15px; border-radius:5px;'>⬅️ Kembali</a>
</center>
