<?php
session_start();
include 'db.php';

// 🔒 Cegah akses tanpa login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

// 🔌 Koneksi ke database
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("<p style='color:red;'>Koneksi gagal: " . htmlspecialchars($conn->connect_error) . "</p>");
}

$pesan = "";
$edit_mode = false;
$nama_edit = $spesialis = $alamat = $nohp = $ket = "";

// 🗑️ Hapus data dokter
if (isset($_POST['hapus'])) {
    $nama_hapus = trim($_POST['hapus']);
    $stmt = $conn->prepare("DELETE FROM dokter WHERE Nama_dokter = ?");
    $stmt->bind_param("s", $nama_hapus);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        $pesan = "<p style='color:green;'>✅ Data dokter <b>" . htmlspecialchars($nama_hapus) . "</b> berhasil dihapus.</p>";
    } else {
        $pesan = "<p style='color:red;'>⚠️ Gagal menghapus data dokter.</p>";
    }
    $stmt->close();
}

// ✏️ Ambil data dokter untuk diedit
if (isset($_POST['edit'])) {
    $nama_edit = trim($_POST['edit']);
    $stmt = $conn->prepare("SELECT Nama_dokter, Spesialis, Alamat_dokter, No_hape, Keterangan FROM dokter WHERE Nama_dokter=?");
    $stmt->bind_param("s", $nama_edit);
    $stmt->execute();
    $stmt->bind_result($nama_edit, $spesialis, $alamat, $nohp, $ket);
    if ($stmt->fetch()) {
        $edit_mode = true;
    }
    $stmt->close();
}

// 💾 Update data dokter
if (isset($_POST['update'])) {
    $nama_lama = trim($_POST['nama_lama']);
    $nama_baru = trim($_POST['nama']);
    $spesialis = trim($_POST['spesialis']);
    $alamat = trim($_POST['alamat']);
    $nohp = trim($_POST['nohp']);
    $ket = trim($_POST['ket']);

    $stmt = $conn->prepare("UPDATE dokter 
                            SET Nama_dokter=?, Spesialis=?, Alamat_dokter=?, No_hape=?, Keterangan=? 
                            WHERE Nama_dokter=?");
    $stmt->bind_param("ssssss", $nama_baru, $spesialis, $alamat, $nohp, $ket, $nama_lama);
    $stmt->execute();

    if ($stmt->affected_rows > 0) {
        $pesan = "<p style='color:green;'>✅ Data dokter berhasil diperbarui!</p>";
    } else {
        $pesan = "<p style='color:orange;'>⚠️ Tidak ada perubahan data.</p>";
    }

    $stmt->close();
    $edit_mode = false;
}

// 🩺 Ambil semua data dokter
$result = $conn->query("SELECT Nama_dokter, Spesialis, Alamat_dokter, No_hape, Keterangan FROM dokter ORDER BY Nama_dokter ASC");
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Data Dokter</title>
<style>
    body { font-family: Verdana, sans-serif; background-color: #f2f2f2; }
    h2 { color: #333; }
    table {
        border-collapse: collapse;
        margin: 20px auto;
        background-color: white;
        box-shadow: 0 0 10px rgba(0,0,0,0.2);
    }
    th, td { padding: 8px 12px; border: 1px solid #000; text-align: left; }
    th { background-color: #4CAF50; color: white; }
    tr:hover { background-color: #f5f5f5; }
    .aksi button {
        padding: 5px 10px;
        border: none;
        border-radius: 5px;
        cursor: pointer;
        color: white;
    }
    .edit-btn { background-color: #2196F3; }
    .hapus-btn { background-color: #f44336; }
    .logout { text-align: center; margin: 20px; }
    .logout a {
        text-decoration: none;
        color: white;
        background: red;
        padding: 8px 16px;
        border-radius: 6px;
    }
    .form-edit {
        background-color: white;
        padding: 20px;
        width: 400px;
        margin: 30px auto;
        border-radius: 10px;
        box-shadow: 0 0 10px rgba(0,0,0,0.3);
    }
    input[type=text], textarea {
        width: 100%;
        padding: 8px;
        margin: 5px 0 10px;
        border-radius: 5px;
        border: 1px solid #aaa;
    }
    input[type=submit] {
        background-color: #4CAF50;
        color: white;
        border: none;
        padding: 10px 20px;
        border-radius: 5px;
        cursor: pointer;
    }
    input[type=submit]:hover {
        background-color: #45a049;
    }
</style>
</head>
<body>

<center>
<h2>Daftar Dokter</h2><br>
<a href="dashboard.php"><font face=verdana size=3>[Kembali]</font></a>

<?= $pesan ?>

<?php if ($edit_mode): ?>
<div class="form-edit">
    <h3>Edit Data Dokter</h3>
    <form method="post">
        <input type="hidden" name="nama_lama" value="<?= htmlspecialchars($nama_edit) ?>">
        Nama Dokter:<br>
        <input type="text" name="nama" value="<?= htmlspecialchars($nama_edit) ?>" required><br>
        Spesialis:<br>
        <input type="text" name="spesialis" value="<?= htmlspecialchars($spesialis) ?>"><br>
        Alamat Dokter:<br>
        <textarea name="alamat"><?= htmlspecialchars($alamat) ?></textarea><br>
        Nomor HP:<br>
        <input type="text" name="nohp" value="<?= htmlspecialchars($nohp) ?>"><br>
        Keterangan:<br>
        <textarea name="ket"><?= htmlspecialchars($ket) ?></textarea><br>
        <input type="submit" name="update" value="Simpan Perubahan">
    </form>
</div>
<?php endif; ?>

<?php
// 🩺 Tampilkan tabel dokter
if ($result && $result->num_rows > 0) {
    echo "<table>";
    echo "<tr>
            <th>Nama Dokter</th>
            <th>Spesialis</th>
            <th>Alamat</th>
            <th>No. Hape</th>
            <th>Keterangan</th>
            <th>Aksi</th>
          </tr>";

    while ($row = $result->fetch_assoc()) {
        $nama = htmlspecialchars($row['Nama_dokter']);
        echo "<tr>";
        echo "<td>" . $nama . "</td>";
        echo "<td>" . htmlspecialchars($row['Spesialis']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Alamat_dokter']) . "</td>";
        echo "<td>" . htmlspecialchars($row['No_hape']) . "</td>";
        echo "<td>" . htmlspecialchars($row['Keterangan']) . "</td>";
        echo "<td class='aksi'>
                <form method='post' style='display:inline;'>
                    <input type='hidden' name='edit' value='" . $nama . "'>
                    <button type='submit' class='edit-btn'>Edit</button>
                </form>
                <form method='post' style='display:inline;' onsubmit='return confirm(\"Yakin ingin menghapus dokter ini?\")'>
                    <input type='hidden' name='hapus' value='" . $nama . "'>
                    <button type='submit' class='hapus-btn'>Hapus</button>
                </form>
              </td>";
        echo "</tr>";
    }

    echo "</table>";
} else {
    echo "<p style='color:red;'>Tidak ada data dokter.</p>";
}
$conn->close();
?>
</center>

<div class="logout">
    <a href="logout.php">Logout</a>
</div>

</body>
</html>
