<?php
session_start();
include 'db.php';

// Cek login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("<p style='color:red;'>Koneksi gagal: " . htmlspecialchars($conn->connect_error) . "</p>");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nama_pasien = trim($_POST['nama'] ?? '');
    $kelamin = trim($_POST['kelamin'] ?? '');
    $umur = trim($_POST['usia'] ?? '');
    $alamat = trim($_POST['alamat'] ?? '');
    $telp = trim($_POST['telp'] ?? '');
    $ket = trim($_POST['keterangan'] ?? '');

    if ($nama_pasien === '' || $kelamin === '' || $umur === '' || $alamat === '' || $telp === '') {
        echo "<p style='color:red; text-align:center;'>⚠️ Harap isi semua kolom wajib!</p>";
    } else {
        $stmt = $conn->prepare("
            INSERT INTO pasien (Nama_pasien, Kelamin, Umur, Alamat, No_hape, Keterangan)
            VALUES (?, ?, ?, ?, ?, ?)
        ");
        $stmt->bind_param("ssssss", $nama_pasien, $kelamin, $umur, $alamat, $telp, $ket);

        if ($stmt->execute()) {
            echo "<p style='color:green; text-align:center;'>✅ Data pasien berhasil disimpan!</p>";
        } else {
            echo "<p style='color:red; text-align:center;'>❌ Terjadi kesalahan saat menyimpan data pasien!</p>";
        }

        $stmt->close();
    }
}
$conn->close();
?>

<html>
<head>
<title>Input Data Pasien</title>
</head>
<body style="font-family:verdana; background-color:#f9f9f9;">
<center>
<h2>🩺 Form Input Data Pasien</h2>
<form method="post" style="background:#ffffff; border:1px solid #ccc; padding:20px; width:450px; border-radius:10px;">
    <label>Nama Lengkap</label><br>
    <input type="text" name="nama" size="40" required><br><br>

    <label>Jenis Kelamin</label><br>
    <input type="radio" name="kelamin" value="L" required> Laki-laki
    <input type="radio" name="kelamin" value="P" required> Perempuan
    <br><br>

    <label>Usia</label><br>
    <input type="number" name="usia" size="10" min="0" max="120" required><br><br>

    <label>Alamat</label><br>
    <input type="text" name="alamat" size="40" required><br><br>

    <label>Nomor HP</label><br>
    <input type="text" name="telp" size="40" required><br><br>

    <label>Keterangan</label><br>
    <textarea name="keterangan" cols="42" rows="4"></textarea><br><br>

    <input type="submit" value="💾 Simpan Data" style="background:#4CAF50; color:white; padding:10px 20px; border:none; border-radius:6px; cursor:pointer;">
</form>

<br>
<a href="dashboard.php">🏠 Kembali ke Dashboard</a>
</center>
</body>
</html>
