<?php
include 'db.php';

// --- Ambil data dari tabel logo ---
$conn = new mysqli($servername, $username, $password, $database);

if ($conn->connect_error) {
    die("Koneksi gagal: " . htmlspecialchars($conn->connect_error));
}

$stmt = $conn->prepare("SELECT Nama_apotek, Nama_apoteker, No_apoteker, Alamat, Logo_apotek FROM logo LIMIT 1");
$stmt->execute();
$stmt->bind_result($nama_ap, $nama_apoteker, $no_apoteker, $alamat_ap, $logo_ap);
$stmt->fetch();
$stmt->close();
$conn->close();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($nama_ap) ?></title>
    <style>
        body {
            margin: 0;
            background-color: #f4f4f4;
            font-family: Verdana, sans-serif;
        }
        table {
            width: 100%;
            height: 100vh;
            border-collapse: collapse;
        }
        td {
            text-align: center;
            vertical-align: middle;
        }
        .header {
            background-color: #999999;
            color: #ffffff;
            padding: 50px 0;
        }
        .header font {
            color: #ffffff;
        }
        .logo img {
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.2);
            transition: transform 0.3s ease;
        }
        .logo img:hover {
            transform: scale(1.05);
        }
    </style>
</head>

<body>

<table>
    <tr>
        <td class="header">
            <font size="8"><?= htmlspecialchars($nama_ap) ?></font><br><br>
            <font size="4"><?= htmlspecialchars($alamat_ap) ?></font><br><br>
            <font size="3"><?= htmlspecialchars($nama_apoteker) ?></font><br><br>
            <font size="3"><?= htmlspecialchars($no_apoteker) ?></font>
        </td>
    </tr>

    <tr>
        <td class="logo">
            <a href="login.php">
                <img src="<?= htmlspecialchars($logo_ap) ?>" alt="Logo Apotek" width="350">
            </a>
        </td>
    </tr>
</table>

</body>
</html>
