<?php
session_start();
include 'db.php'; // koneksi database

if (!isset($_SESSION['username'])) {
   header("Location: login.php");
   exit;
}

// Buat koneksi
$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
   die("Koneksi gagal: " . $conn->connect_error);
}

// -------------------------------------------------------------
// 1️⃣  Jika tombol "Ya" ditekan → Backup dulu, lalu TRUNCATE
// -------------------------------------------------------------
if (isset($_POST['konfirmasi']) && $_POST['konfirmasi'] === 'ya') {

   // Pastikan folder backup ada
   $backup_dir = __DIR__ . "/backup";
   if (!is_dir($backup_dir)) {
      mkdir($backup_dir, 0777, true);
   }

   // Nama file backup dengan tanggal
   $tanggal = date("Ymd_His");
   $nama_file = $backup_dir . "/backup_transaksi_$tanggal.sql";

   // Ambil semua data transaksi untuk disimpan
   $result = $conn->query("SELECT * FROM transaksi");
   if ($result && $result->num_rows > 0) {
      $backup_data = "";
      while ($row = $result->fetch_assoc()) {
         $cols = array_map(fn($v) => $conn->real_escape_string($v), array_values($row));
         $backup_data .= "INSERT INTO transaksi VALUES ('" . implode("','", $cols) . "');\n";
      }

      file_put_contents($nama_file, $backup_data);
   }

   // Jalankan TRUNCATE TABLE
   $conn->query("TRUNCATE TABLE transaksi");

   echo "<center><font face='verdana' size='4' color='green'>
   ✅ Semua data transaksi telah dihapus dan backup tersimpan di folder <b>backup/</b><br>
   File: <b>backup_transaksi_$tanggal.sql</b>
   </font><br><br>
   <a href='dashboard.php'>Kembali ke Dashboard</a></center>";

   $conn->close();
   exit;
}

// -------------------------------------------------------------
// 2️⃣  Jika tombol "Tidak" ditekan
// -------------------------------------------------------------
if (isset($_POST['konfirmasi']) && $_POST['konfirmasi'] === 'tidak') {
   header("Location: dashboard.php");
   exit;
}
?>

<html>
<head>
   <title>Hapus Semua Transaksi</title>
</head>
<body>
   <center>
      <font face="verdana" size="5"><b>Konfirmasi Penghapusan Data Transaksi</b></font><br><br>
      <font face="verdana" size="3" color="red">
      Apakah Anda yakin ingin menghapus <b>semua data transaksi</b> dari tabel?
      </font><br><br>

      <form method="post">
         <button type="submit" name="konfirmasi" value="ya">✅ Ya, hapus semua</button>
         &nbsp;&nbsp;&nbsp;
         <button type="submit" name="konfirmasi" value="tidak">❌ Tidak</button>
      </form>
   </center>
</body>
</html>
