<?php
// hapus_op.php
session_start();
include 'db.php';

// 🔒 Hanya admin yang boleh
if (!isset($_SESSION['username']) || $_SESSION['username'] !== 'admin') {
    header("Location: login.php");
    exit;
}

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

$message = "";

// Tahap 1: cari user
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['user']) && !isset($_POST['konfirmasi'])) {
    $user = trim($_POST['user']);

    $stmt = $conn->prepare("SELECT username FROM operator WHERE username = ?");
    $stmt->bind_param("s", $user);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 0) {
        $message = "<p style='color:red;'>⚠️ Username tidak ditemukan!</p>";
    } else {
        $data = $result->fetch_assoc();
        $message = "
        <table border='1' cellpadding='10' cellspacing='0' style='margin:auto; font-family:verdana;'>
            <tr bgcolor='#e0e0e0'><th>Username</th></tr>
            <tr><td>{$data['username']}</td></tr>
        </table>
        <br>
        <form method='post'>
            <input type='hidden' name='user' value='{$data['username']}'>
            <input type='hidden' name='konfirmasi' value='ya'>
            <input type='submit' value='✅ YA, Hapus!' 
                style='background:red;color:white;font-weight:bold;padding:10px 20px;border:none;border-radius:5px;cursor:pointer;'>
            &nbsp;&nbsp;
            <a href='hapus_op.php' 
                style='background:gray;color:white;text-decoration:none;padding:10px 20px;border-radius:5px;'>❌ Tidak</a>
        </form>
        ";
    }

    $stmt->close();
}

// Tahap 2: konfirmasi hapus
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['konfirmasi']) && $_POST['konfirmasi'] === 'ya') {
    $user = trim($_POST['user']);

    $stmt = $conn->prepare("DELETE FROM operator WHERE username = ?");
    $stmt->bind_param("s", $user);

    if ($stmt->execute()) {
        $message = "<p style='color:green;font-family:verdana;'>✅ Akun <b>$user</b> berhasil dihapus.</p>";
    } else {
        $message = "<p style='color:red;font-family:verdana;'>❌ Gagal menghapus akun.</p>";
    }
    $stmt->close();
}

$conn->close();
?>

<html>
<head>
<title>Hapus Akun Operator</title>
</head>
<body style="font-family:verdana; text-align:center; margin-top:50px;">
    <h2>🗑️ Hapus Akun Operator</h2>

    <form method="post" style="margin-bottom:30px;">
        Masukkan username operator yang akan dihapus:<br><br>
        <input type="text" name="user" size="30" required>
        <br><br>
        <input type="submit" value="Cari"
            style="background:blue;color:white;font-weight:bold;padding:8px 16px;border:none;border-radius:5px;cursor:pointer;">
    </form>

    <?= $message ?>

    <br><br>
    <a href="dashboard.php" style="text-decoration:none;color:#0066cc;">⬅️ Kembali ke Dashboard</a>
</body>
</html>
