<?php
session_start();
include 'db.php';

// Cek login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

$pesan = "";
$tampil_konfirmasi = false;
$dokter_ditemukan = [];

$conn = new mysqli($servername, $username, $password, $database);
if ($conn->connect_error) {
    die("<p style='color:red;'>Koneksi gagal: " . htmlspecialchars($conn->connect_error) . "</p>");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    // Tahap 1: user mengetik nama
    if (isset($_POST['cari'])) {
        $dokter_hapus = trim($_POST['dokter_hapus'] ?? '');

        if ($dokter_hapus === '') {
            $pesan = "<p style='color:red;'>⚠️ Nama dokter harus diisi!</p>";
        } else {
            // Cari nama yang cocok (tidak case sensitive, mengandung 1 kata)
            $stmt = $conn->prepare("
                SELECT no_id, Nama_dokter, Spesialis 
                FROM dokter 
                WHERE Nama_dokter COLLATE utf8mb4_unicode_ci LIKE CONCAT('%', ?, '%')
            ");
            $stmt->bind_param("s", $dokter_hapus);
            $stmt->execute();
            $result = $stmt->get_result();

            if ($result->num_rows > 0) {
                while ($row = $result->fetch_assoc()) {
                    $dokter_ditemukan[] = $row;
                }
                $tampil_konfirmasi = true;
            } else {
                $pesan = "<p style='color:orange;'>⚠️ Tidak ditemukan dokter yang cocok dengan kata '<b>" . htmlspecialchars($dokter_hapus) . "</b>'.</p>";
            }

            $stmt->close();
        }
    }

    // Tahap 2: user menekan tombol YA
    if (isset($_POST['konfirmasi']) && $_POST['konfirmasi'] === 'ya') {
        $kata_kunci = trim($_POST['kata_kunci'] ?? '');
        $stmt = $conn->prepare("
            SELECT no_id FROM dokter 
            WHERE Nama_dokter COLLATE utf8mb4_unicode_ci LIKE CONCAT('%', ?, '%')
        ");
        $stmt->bind_param("s", $kata_kunci);
        $stmt->execute();
        $result = $stmt->get_result();

        $hapus_count = 0;
        while ($row = $result->fetch_assoc()) {
            $hapus = $conn->prepare("DELETE FROM dokter WHERE no_id = ?");
            $hapus->bind_param("i", $row['no_id']);
            $hapus->execute();
            if ($hapus->affected_rows > 0) $hapus_count++;
            $hapus->close();
        }

        if ($hapus_count > 0) {
            $pesan = "<p style='color:green;'>✅ Dihapus $hapus_count data dokter yang cocok dengan '<b>" . htmlspecialchars($kata_kunci) . "</b>'.</p>";
        } else {
            $pesan = "<p style='color:orange;'>⚠️ Tidak ada data yang terhapus.</p>";
        }

        $stmt->close();
    }

    // Tahap 3: user menekan tombol TIDAK
    if (isset($_POST['konfirmasi']) && $_POST['konfirmasi'] === 'tidak') {
        $pesan = "<p style='color:blue;'>ℹ️ Penghapusan dibatalkan oleh pengguna.</p>";
    }
}

$conn->close();
?>

<html>
<head>
<title>Penghapusan Data Dokter</title>
<style>
body {
    font-family: Verdana, sans-serif;
    background-color: #f9f9f9;
    text-align: center;
    margin-top: 50px;
}
.container {
    background: white;
    border: 1px solid #ccc;
    width: 600px;
    margin: auto;
    padding: 25px;
    border-radius: 10px;
    box-shadow: 0 0 10px rgba(0,0,0,0.1);
}
input[type="text"] {
    width: 80%;
    padding: 8px;
    font-size: 14px;
}
button {
    background-color: #c82333;
    color: white;
    border: none;
    padding: 10px 20px;
    font-size: 14px;
    border-radius: 5px;
    cursor: pointer;
}
button:hover {
    background-color: #a71d2a;
}
.btn-no {
    background-color: gray;
}
.btn-no:hover {
    background-color: #555;
}
a {
    color: #0066cc;
    text-decoration: none;
}
a:hover {
    text-decoration: underline;
}
table {
    border-collapse: collapse;
    width: 100%;
    margin-top: 10px;
}
th, td {
    border: 1px solid #ddd;
    padding: 8px;
    text-align: left;
}
th {
    background-color: #f2f2f2;
}
</style>
</head>
<body>

<div class="container">
    <h2>🩺 Penghapusan Data Dokter</h2>

    <?php if (!$tampil_konfirmasi): ?>
    <!-- Form pencarian -->
    <form method="post">
        Masukkan 1 kata nama dokter yang akan dihapus:<br><br>
        <input type="text" name="dokter_hapus" placeholder="Contoh: budi"><br><br>
        <input type="submit" name="cari" value="Cari">
    </form>
    <?php endif; ?>

    <?php if ($tampil_konfirmasi): ?>
        <p>Apakah Anda yakin ingin menghapus data berikut?</p>
        <table>
            <tr><th>ID</th><th>Nama Dokter</th><th>Spesialis</th></tr>
            <?php foreach ($dokter_ditemukan as $d): ?>
                <tr>
                    <td><?= htmlspecialchars($d['no_id']) ?></td>
                    <td><?= htmlspecialchars($d['Nama_dokter']) ?></td>
                    <td><?= htmlspecialchars($d['Spesialis']) ?></td>
                </tr>
            <?php endforeach; ?>
        </table>
        <br>
        <form method="post">
            <input type="hidden" name="kata_kunci" value="<?= htmlspecialchars($_POST['dokter_hapus']) ?>">
            <button type="submit" name="konfirmasi" value="ya">✅ Ya, Hapus</button>
            <button type="submit" name="konfirmasi" value="tidak" class="btn-no">❌ Tidak</button>
        </form>
    <?php endif; ?>

    <br>
    <?= $pesan ?>
    <br>
    <a href="dashboard.php">⬅️ Kembali ke Dashboard</a>
</div>

</body>
</html>
