<?php
session_start();
include 'db.php';

// 🔒 Pastikan user login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user    = trim($_SESSION['username'] ?? '');
    $lama    = trim($_POST['lama'] ?? '');
    $sandi1  = trim($_POST['sandi1'] ?? '');
    $sandi2  = trim($_POST['sandi2'] ?? '');

    // 🔗 Koneksi database
    $conn = new mysqli($servername, $username, $password, $database);
    if ($conn->connect_error) {
        die("<p style='color:red; text-align:center;'>Koneksi gagal: " . htmlspecialchars($conn->connect_error) . "</p>");
    }

    // 🔍 Ambil password lama
    $stmt = $conn->prepare("SELECT password FROM operator WHERE username = ?");
    $stmt->bind_param("s", $user);
    $stmt->execute();
    $stmt->bind_result($hash_lama);
    $stmt->fetch();
    $stmt->close();

    if (!$hash_lama) {
        echo "<p style='color:red; text-align:center; font-family:verdana;'>⚠️ Akun tidak ditemukan!</p>";
        $conn->close();
        exit;
    }

    // 🔐 Verifikasi password lama
    if (!password_verify($lama, $hash_lama)) {
        echo "<p style='color:red; text-align:center; font-family:verdana;'>❌ Password lama salah!</p>";
        $conn->close();
        exit;
    }

    // 💡 Cek kesamaan password baru
    if ($sandi1 !== $sandi2) {
        echo "<p style='color:red; text-align:center; font-family:verdana;'>⚠️ Password baru harus sama!</p>";
        $conn->close();
        exit;
    }

    // 💡 Minimal 6 karakter
    if (strlen($sandi1) < 6) {
        echo "<p style='color:red; text-align:center; font-family:verdana;'>⚠️ Password baru minimal 6 karakter!</p>";
        $conn->close();
        exit;
    }

    // 🔐 Hash password baru
    $hashed_baru = password_hash($sandi1, PASSWORD_DEFAULT);

    // 🔄 Update password
    $stmt = $conn->prepare("UPDATE operator SET password = ? WHERE username = ?");
    $stmt->bind_param("ss", $hashed_baru, $user);

    if ($stmt->execute()) {
        echo "<p style='color:green; text-align:center; font-family:verdana;'>✅ Password berhasil diganti!</p>";
    } else {
        echo "<p style='color:red; text-align:center; font-family:verdana;'>❌ Gagal mengganti password!</p>";
    }

    $stmt->close();
    $conn->close();
}
?>

<html>
<head>
<title>Ganti Sandi</title>
<style>
body {
    font-family: Verdana, sans-serif;
    background-color: #f8f8f8;
    color: #333;
}
input[type=password], input[type=submit] {
    font-size: 18px;
    padding: 6px;
}
.eye {
    cursor: pointer;
    font-size: 18px;
    margin-left: 5px;
}
a {
    text-decoration: none;
    color: blue;
}
</style>
<script>
function togglePassword(id, iconId) {
    const input = document.getElementById(id);
    const icon = document.getElementById(iconId);
    if (input.type === "password") {
        input.type = "text";
        icon.textContent = "🙈";
    } else {
        input.type = "password";
        icon.textContent = "👁️";
    }
}
</script>
</head>

<body>
<form method="post">
<center>
<font face="verdana" size="6">🔒 Ganti Sandi Operator</font><br><br><br>

Masukkan Password Lama:<br>
<input type="password" id="lama" name="lama" size="30" required>
<span class="eye" id="eye1" onclick="togglePassword('lama','eye1')">👁️</span><br><br>

Masukkan Password Baru:<br>
<input type="password" id="sandi1" name="sandi1" size="30" required>
<span class="eye" id="eye2" onclick="togglePassword('sandi1','eye2')">👁️</span><br><br>

Ulangi Password Baru:<br>
<input type="password" id="sandi2" name="sandi2" size="30" required>
<span class="eye" id="eye3" onclick="togglePassword('sandi2','eye3')">👁️</span><br><br><br>

<input type="submit" value="Kirim"><br><br><br>
<a href="dashboard.php">[Kembali]</a>
</center>
</form>
</body>
</html>
