<?php
session_start();
include 'db.php';

// Cek login
if (!isset($_SESSION['username'])) {
    header("Location: login.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
<meta charset="UTF-8">
<title>Dashboard Apotek</title>
<style>
    body {
        font-family: Verdana, sans-serif;
        background: linear-gradient(to bottom right, #e0f7fa, #ffffff);
        color: #003366;
        text-align: center;
        padding-top: 50px;
    }

    h1 {
        font-size: 36px;
        margin-bottom: 10px;
    }

    .username {
        font-size: 20px;
        color: #00796b;
    }

    .menu {
        margin-top: 40px;
        display: inline-block;
        text-align: left;
        background: #f9f9f9;
        padding: 25px 50px;
        border-radius: 15px;
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }

    .menu a {
        display: block;
        margin: 8px 0;
        font-size: 16px;
        color: #004d99;
        text-decoration: none;
        transition: 0.2s;
    }

    .menu a:hover {
        color: #d32f2f;
        font-weight: bold;
    }

    .danger {
        color: #cc0000;
        font-weight: bold;
    }
</style>
</head>
<body>

    <h1>Control Panel</h1>
    <p class="username">Selamat datang, <b><?= htmlspecialchars($_SESSION['username']) ?></b></p>

    <div class="menu">
        <a href="logout.php">Logout</a>
        <a href="setup.php">Setup Apotek</a>
        <a href="register.php">Pendaftaran Operator Baru (Only Admin)</a>
        <a href="ganti_sandi.php">Ganti Password Operator</a>
        <a href="lihat_op.php">Lihat Semua Operators (Only Admin)</a>
        <a href="hapus_op.php">Hapus Akun Operator (Only Admin)</a>
        <a href="isi_obat.php">Isi Obat Baru</a>
        <a href="isi_pasien.php">Isi Data Pasien</a>
        <a href="isi_dokter.php">Isi Data Dokter Baru</a>
        <a href="hapus_obat.php">Hapus Obat</a>
        <a href="hapus_pasien.php">Hapus Pasien</a>
        <a href="hapus_dokter.php">Hapus Data Dokter</a>
        <a href="update_obat.php">Edit Data Obat</a>
        <a href="update_pasien.php">Edit Data Pasien</a>
        <a href="update_dokter.php">Edit Data Dokter</a>
        <a href="lihat_obat.php">Lihat Semua Data Obat</a>
        <a href="lihat_pasien.php">Lihat Semua Pasien</a>
        <a href="lihat_dokter.php">Lihat Semua Data Dokter</a>
        <a href="trans1.php">Transaksi Tanpa Resep Dokter</a>
        <a href="trans2.php">Transaksi Dengan Resep Dokter</a>
        <a href="lihat_trans.php">Lihat Semua Transaksi</a>
        <a href="cekout.php">Cetak Kwitansi</a>
        <a href="laporan_keuntungan.php">Laporan Keuangan</a>
        <a class="danger" href="hapus_belum_lunas.php">Hapus Transaksi Belum Lunas</a>
        <a class="danger" href="hapus_transaksi.php">Hapus Semua Transaksi</a>
    </div>

</body>
</html>
